% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/willoughby2006eqs.R
\name{will1}
\alias{will1}
\title{Model wind speed at a grid point for a storm track observation}
\usage{
will1(cdist, Rmax, R1, R2, vmax_gl, n, A, X1, X2 = 25)
}
\arguments{
\item{cdist}{Distance (in km) from center of tropical cyclone to grid point.}

\item{Rmax}{Numeric vector of the radius at which the maximum wind occurs,
in kilometers}

\item{R1}{A numeric vector of one of the parameters of the Willoughby model.}

\item{R2}{A numeric vector of one of the parameters of the Willoughby model.}

\item{vmax_gl}{Numeric vector of the tangential wind component of the maximum
gradient wind speed, in meters per second}

\item{n}{A numeric vector of one of the parameters of the Willoughby model.}

\item{A}{A numeric vector of one of the parameters of the Willoughby model.}

\item{X1}{A numeric vector of one of the parameters of the Willoughby model.}

\item{X2}{A numeric vector of one of the parameters of the Willoughby model.}
}
\value{
Returns a numeric vector with gradient wind speed at a radius of
   \eqn{r} from the storm's center, in meters per second.
}
\description{
Models the gradient wind speed at a certain radius from
a storm's center. To do this, it uses different equations and subfunctions
depending on how large the radius is (see details). This function requires,
as inputs, Willoughby wind model parameters calculated using the
\code{\link{add_wind_radii}} function.
}
\details{
If \eqn{r \le R_1}{r \le R1}, this function is calculating the equation:

   \deqn{V(r) = V_i = V_{max} \left( \frac{r}{R_{max}} \right)^n}{
   V(r) = Vi = vmax_gl (r / Rmax)^n}

   where:
   \itemize{
     \item{\eqn{V(r)}: Maximum sustained gradient wind speed at a radius of
       \eqn{r} from the storm's center}
     \item{\eqn{r}: Radius from the storm center, in kilometers}
     \item{\eqn{V_{max,G}}{vmax_gl}: Maximum sustained gradient wind speed of the
       storm, in meters per second}
     \item{\eqn{R_1}{R1}: A parameter for the Willoughby wind model (radius to
       start of transition region)}
     \item{\eqn{R_{max}}{Rmax}: Radius (in kilometers) to highest winds}
     \item{\eqn{n}: A parameter for the Willoughby wind model}
   }

   If \eqn{R_2 < r}{R2 \le r}, this function is calculating
     the equation:

     \deqn{V(r) = V_o = V_{max}\left[(1 - A) e^\frac{R_{max} - r}{X_1} + A e^\frac{R_{max} - r}{X_2}\right]}{
     V(r) = Vo = vmax_gl[(1 - A) e^((Rmax - r) / X1) + A e^((Rmax - r) / X_2)]}

   where:
   \itemize{
     \item{\eqn{V(r)}: Maximum sustained gradient wind speed at a radius of
       \eqn{r} kilometers from the storm's center}
     \item{\eqn{r}: Radius from the storm center, in kilometers}
     \item{\eqn{V_{max,G}}{vmax_gl}: Maximum sustained gradient wind speed of the
       storm, in meters per second}
     \item{\eqn{R_{max}}{Rmax}: Radius (in kilometers) to highest winds}
     \item{\eqn{A}, \eqn{X_1}{X1}, \eqn{X_2}{X2}: Parameters for the
        Willoughby wind model}
   }

   If \eqn{R_1 < r \le R_2}{R1 < r \le R2}, this function uses
     the equations:

     \deqn{\xi = \frac{r - R_1}{R_2 - R_1}}{
     \xi = (r - R1) / (R2 - R1)}

     and, if \eqn{0 \le \xi < \le 1} (otherwise, \eqn{w = 0}):

     \deqn{w = 126 \xi^5 - 420 \xi^6 + 540 \xi^7- 315 \xi^8 + 70 \xi^9}

     and then:

     \deqn{V(r) = V_i (1 - w) + V_o w, (R_1 \le r \le R_2)}{
     V(r) = Vi (1 - w) + Vo w}

   where, for this series of equations:
   \itemize{
     \item{\eqn{V(r)}: Maximum sustained gradient wind speed at a radius of
       \eqn{r} kilometers from the storm's center}
     \item{\eqn{r}: Radius from the storm center, in kilometers}
     \item{\eqn{w}: Weighting variable}
     \item{\eqn{R_1}{R1}, \eqn{R_2}{R2}: Parameters for the Willoughby wind model}
   }
}
\references{
Willoughby HE, Darling RWR, and Rahn ME. 2006. Parametric representation
of the primary hurricane vortex. Part II: A new family of sectionally
continuous profiles. Monthly Weather Review 134(4):1102-1120.
}
