% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mig_flux_factor.R
\name{get_mig_flux_factor}
\alias{get_mig_flux_factor}
\title{Migration Flux factor}
\usage{
get_mig_flux_factor(n_turbines, rotor_radius, wf_width, popn_est)
}
\arguments{
\item{n_turbines}{An integer. The number of turbines on the wind farm (\eqn{T}).}

\item{rotor_radius}{An integer. The radius of the rotor (\eqn{R}), in metres}

\item{wf_width}{An integer. The width (in km) of the}

\item{popn_est}{An integer. The population estimate from the spatial line sampling technique}
}
\value{
The number of bird flights potentially transiting through rotors
at each time period (assuming no avoidance), if all flights occur within the
rotor's circular area
}
\description{
Returns the migratory flux factor, expressing the total number of
bird flights through the rotors of the wind farm per month, if all flights
occur within the rotor's circle area of all turbines, and assuming birds take no
avoiding action.
}
\details{
The flux factor is used for other model calculations.
Methodology and assumptions underpinning
\code{get_mig_flux_factor} are described in "Stage B" of
\href{https://www.bto.org/sites/default/files/u28/downloads/Projects/Final_Report_SOSS02_Band1ModelGuidance.pdf}{Band (2012)}
}
\examples{
get_mig_flux_factor(
     n_turbines = 100,
     rotor_radius = 120,
     wf_width = 51,
     popn_est = 10000
)
}
