% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeLdac.R
\name{writeLdac}
\alias{writeLdac}
\title{Write a .ldac file}
\usage{
writeLdac(documents, file, zeroindex = TRUE)
}
\arguments{
\item{documents}{A documents object to be written out to a file.  Object
must be a list of with each element corresponding to a document.  Each
document is represented as an integer matrix with two rows, and columns
equal to the number of unique vocabulary words in the document.  The first
row contains the 1-indexed vocabulary entry and the second row contains the
number of times that term appears}

\item{file}{A character string giving the name of the file to be written.
This object is passed directly to the argument \code{con} in
\code{\link{writeLines}} and thus can be a connection object as well.}

\item{zeroindex}{If \code{TRUE} (the default) it subtracts one
from each index.  If \code{FALSE} it uses the indices as given.  The
standard \code{.ldac} format indexes from 0 as per standard convention in
most languages.  Our documents format indexes from 1 to abide by conventions
in \code{R}.  This option converts to the zero index by default.}
}
\description{
A function for writing documents out to a .ldac formated file.
}
\details{
This is a simple convenience function for writing out document corpora.
Files can be read back into R using \code{\link{readCorpus}} or simply used
for other programs.  The output is a file in the \code{.ldac} sparse matrix
format popularized by Dave Blei's C code for LDA.
}
\examples{

\dontrun{

#Convert the gadarian data into documents format
temp<-textProcessor(documents=gadarian$open.ended.response,metadata=gadarian)
documents <- temp$documents
#Now write out to an ldac file
writeLdac(documents, file="gadarian.ldac")
}
}
\seealso{
\code{\link{readCorpus}}
}
