% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.searchK.R
\name{plot.searchK}
\alias{plot.searchK}
\title{Plots diagnostic values resulting from searchK}
\usage{
\method{plot}{searchK}(x, ...)
}
\arguments{
\item{x}{A searchK object, containing the diagnostic information of an stm
with a variety of topics.}

\item{...}{additional arguments for S3 compatability.}
}
\description{
Takes the result of searchK and produces a set of plots for evaluating
optimal topic numbers via visual representation of diagnostic functions.
}
\examples{

\dontrun{

K<-c(5,10,15) 
temp<-textProcessor(documents=gadarian$open.ended.response,metadata=gadarian)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta)
documents <- out$documents
vocab <- out$vocab
meta <- out$meta
set.seed(02138)
K<-c(5,10,15) 
kresult <- searchK(documents, vocab, K, prevalence=~treatment + s(pid_rep), data=meta)

plot(kresult)
}
 
}
