% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binred_plot.R
\name{binred_plot}
\alias{binred_plot}
\title{Generate a Binned-Residual Plot from a Fitted Generalized Linear Model}
\usage{
binred_plot(model, nbins, plot = TRUE)
}
\arguments{
\item{model}{a fitted GLM model, assuming link is "logit"}

\item{nbins}{number of "bins" for the calculation. Defaults to the rounded
square root of the number of observations in the model in the absence of a
user-specified override here.}

\item{plot}{logical, defaults to TRUE. If TRUE, the function plots the
binned residuals. If FALSE, the function returns a data frame of the
binned residuals.}
}
\value{
\code{bindred_plot()} returns a plot as a \pkg{ggplot2} object, as
a default. The \emph{y}-axis is the mean residuals of the particular bin. The
\emph{x}-axis is the mean fitted values from the bin. Error bounds are 95\%.
A LOESS smoother is overlaid as a solid blue line.

If \code{plot = FALSE}, the function returns a data frame of the binned residuals
and a summary about whether the residuals are in the error bounds.
}
\description{
\code{binred_plot()} provides a diagnostic of the fit of
the generalized linear model by "binning" the fitted and residual values
from the model and showing where they may fall outside 95\% error bounds.
}
\details{
The number of bins the user wants is arbitrary. Gelman and Hill
(2007) say that, for larger data sets (n >= 100), the number of bins should
be the rounded-down square root of the number of observations from the model.
For models with a number of observations between 10 and 100, the number of
bins should be 10. For models with fewer than 10 observations, the number
of bins should be the rounded-down number of observations (divided by 2).
The default is the rounded square root of the number of observations in
the model. Be smart about what you want here.
}
\examples{

M1 <- glm(vs ~ mpg + cyl + drat, data=mtcars, family=binomial(link="logit"))

binred_plot(M1)
}
\author{
Steven V. Miller
}
