% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_dispersal-functions.R
\name{kernel_dispersal}
\alias{kernel_dispersal}
\title{Kernel-based dispersal}
\usage{
kernel_dispersal(
  dispersal_kernel = exponential_dispersal_kernel(distance_decay = 1),
  max_distance = NULL,
  arrival_probability = c("both", "suitability", "carrying_capacity", "none"),
  dispersal_proportion = set_proportion_dispersing()
)
}
\arguments{
\item{dispersal_kernel}{a single built-in or user-defined distance dispersal
kernel function.}

\item{max_distance}{the maximum distance that each life stage can
disperse in spatial units of the landscape (in kernel-based dispersal
this truncates the dispersal curve). Setting a reasonable number will
increase the performance of a simulation by reducing the number of cells
that need to be calculated in distance matrices.}

\item{arrival_probability}{the name of a spatial layer in the landscape object
that controls where individuals can disperse to (e.g. "suitability") or
"none" to allow individuals to disperse to all non-NA cells. The default is
to use both the habitat suitability and carrying capacity layers. When this
option is selected, the arrival probability in each cell is calculated by
multiplying the habitat suitability by one minus the proportion of space taken
up in the cell (total population of life stages contributing to density
dependence divided by the carrying capacity).}

\item{dispersal_proportion}{a built-in or custom function defining the proportions
of individuals that can disperse in each life stage.}
}
\description{
The kernel_dispersal function employs a probabilistic
kernel-based dispersal algorithm to modify the population
using a user-defined diffusion distribution (see
\link[steps]{dispersal_kernel}), arrival probability layers
(e.g. habitat suitability), and growth limiting layers (e.g.
carrying capacity). This function is much slower than the
\link[steps]{fast_dispersal}, however, respects dispersal
limitations which may be more ecologically appropriate. Further, 
the kernel-based dispersal function utilises a mechanism to
optimise computational performance in which it switches between
pre-allocating cell movements based on the available memory of
the host computer (faster but more memory intensive) or executing
cell movements in sequence (slower but less memory intensive).
}
\examples{

# Example of kernel-based dispersal where only the 3rd life stage
# disperses up to a maximum distance of 2000 meters. Dispersal is affected
# by both habitat suitability and carrying capacity (default). The default
# dispersal kernel uses a decay parameter to control how far populations disperse. 

\dontrun{
kb_dispersal <- kernel_dispersal(max_distance = 2000,
                      dispersal_kernel = exponential_dispersal_kernel(distance_decay = 1000))

ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = egk_k)

pd <- population_dynamics(change = growth(egk_mat),
                          dispersal = kb_dispersal,
                          density_dependence = ceiling_density())

simulation(landscape = ls, population_dynamics = pd, habitat_dynamics = NULL, timesteps = 20)
}
}
