% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTrades.R
\name{getTrades}
\alias{getTrades}
\title{Returns all trades.}
\usage{
getTrades(cursor = NULL, limit = 10, order = "asc", data.table = TRUE,
  base_asset_type = NULL, base_asset_code = NULL,
  base_asset_issuer = NULL, counter_asset_type = NULL,
  counter_asset_code = NULL, counter_asset_issuer = NULL, offer_id = NULL)
}
\arguments{
\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{limit}{numeric - optional, the number of records to return. Default is 10.}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}

\item{base_asset_type}{optional, string - type of base asset}

\item{base_asset_code}{optional, string - code of base asset, not required if type is native}

\item{base_asset_issuer}{optional, string - issuer of base asset, not required if type is native}

\item{counter_asset_type}{optional, string - type of counter asset}

\item{counter_asset_code}{optional, string - code of counter asset, not required if type is native}

\item{counter_asset_issuer}{optional, string - issuer of counter asset, not required if type is native}

\item{offer_id}{optional, string - filter for by a specific offer id}
}
\value{
data.table or list
}
\description{
Return all partially fulfilled trades to buy or sell assets on the ledger.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/trades.html
}
\examples{
getTrades(limit = 20)
}
