% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_stdmod_lavaan.R
\name{print.stdmod_lavaan}
\alias{print.stdmod_lavaan}
\title{Print a 'stdmod_lavaan' Class Object}
\usage{
\method{print}{stdmod_lavaan}(x, conf = 0.95, nd = 3, ...)
}
\arguments{
\item{x}{The output of \code{\link[=stdmod_lavaan]{stdmod_lavaan()}}.}

\item{conf}{If nonparametric bootstrapping has been conducted by
\code{\link[=stdmod_lavaan]{stdmod_lavaan()}},
this is the level of confidence in proportion (.95 denotes 95\%),
of the confidence interval. Default is .95.}

\item{nd}{The number of digits to be printed.}

\item{...}{Optional arguments. Ignored.}
}
\value{
\code{x} is returned invisibly.
}
\description{
Print the output of \code{\link[=stdmod_lavaan]{stdmod_lavaan()}}.
}
\examples{

# Load a test data of 500 cases

dat <- test_mod1
library(lavaan)

mod <-
"
med ~ iv + mod + iv:mod + cov1
dv ~ med + cov2
"
fit <- sem(mod, dat)
coef(fit)

# Compute the standardized moderation effect
out_noboot <- stdmod_lavaan(fit = fit,
                            x = "iv",
                            y = "med",
                            w = "mod",
                            x_w = "iv:mod")
out_noboot

# Compute the standardized moderation effect and
# its percentile confidence interval based on nonparametric bootstrapping
set.seed(8479075)
system.time(out_boot <- stdmod_lavaan(fit = fit,
                                      x = "iv",
                                      y = "med",
                                      w = "mod",
                                      x_w = "iv:mod",
                                      boot_ci = TRUE,
                                      R = 50))
# In real analysis, R should be at least 2000.

out_boot


}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
