% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdmod_lavaan.R
\name{stdmod_lavaan}
\alias{stdmod_lavaan}
\title{Standardized Moderation Effect and Its Bootstrap CI in 'lavaan'}
\usage{
stdmod_lavaan(
  fit,
  x,
  y,
  w,
  x_w,
  standardized_x = TRUE,
  standardized_y = TRUE,
  standardized_w = TRUE,
  boot_ci = FALSE,
  boot_out = NULL,
  R = 100,
  conf = 0.95,
  use_old_version = FALSE,
  ...
)
}
\arguments{
\item{fit}{The SEM output by \code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrappers.}

\item{x}{The name of the focal variable in the model, the variable with
its effect on the outcome variable being moderated.}

\item{y}{The name of the outcome variable (dependent variable) in the model.}

\item{w}{The name of the moderator in the model.}

\item{x_w}{The name of the product term (x * w) in the model. It can be
the variable generated by the colon operator, e.g., \code{"x:w"},
which is only in the model and not in the original data set.}

\item{standardized_x}{If \code{TRUE}, the default, \code{x} is standardized when
computing the standardized moderation effect.}

\item{standardized_y}{If \code{TRUE}, the default, \code{y} is standardized when
computing the standardized moderation effect.}

\item{standardized_w}{If \code{TRUE}, the default, \code{w} is standardized when
computing the standardized moderation effect.}

\item{boot_ci}{Boolean. Whether nonparametric bootstrapping will be
conducted. Default is \code{FALSE}.}

\item{boot_out}{If set to the output of \code{\link[manymome:do_boot]{manymome::do_boot()}}, the stored
bootstrap estimates will be retrieved to form the bootstrap confidence
interval. If set, bootstrap estimates stored in \code{fit}, if any, will not
be used. Default is \code{NULL}.}

\item{R}{(Not used in the current version. Used when \code{use_old_version}
is set to \code{TRUE}.)
The number of nonparametric bootstrapping samples. Default is 100.
Set this to at least 2000 in actual use.}

\item{conf}{The level of confidence. Default is .95, i.e., 95\%.}

\item{use_old_version}{If set to \code{TRUE}, it will use the bootstrapping
method used in 0.2.7.4 or before. Included only for reproducing
previous results if necessary. Default is \code{FALSE}.}

\item{...}{(Not used in the current version. Used when \code{use_old_version}
is set to \code{TRUE}.) Optional arguments to be passed to \code{\link[boot:boot]{boot::boot()}}. Parallel
processing can be used by adding the appropriate arguments in
\code{\link[boot:boot]{boot::boot()}}.}
}
\value{
A list of class \code{stdmod_lavaan} with these elements:
\itemize{
\item \code{stdmod}: The standardized moderation effect.
\item \code{ci}: The nonparametric bootstrap confidence interval. \code{NA} if
confidence interval not requested.
\item \code{boot_out}: The raw output from \code{\link[boot:boot]{boot::boot()}}. \code{NA} if
confidence interval not requested.
\item \code{fit}: The original fit object.
}
}
\description{
Compute the standardized moderation effect in a structural
equation model fitted by \code{\link[lavaan:lavaan]{lavaan::lavaan()}} or its wrappers and
form the nonparametric bootstrap confidence interval.
}
\details{
\subsection{Important Notes}{

Starting from Version 0.2.7.5, of \code{\link[=stdmod_lavaan]{stdmod_lavaan()}} adopts an approach
to bootstrapping different from that in the previous
versions (0.2.7.4 and before),
yielding bootstrapping results different from those in
previous versions (for reasons explained later).

To reproduce results from the older version of this function,
set \code{use_old_version} to \code{TRUE}.
}

\subsection{How it works}{

\code{\link[=stdmod_lavaan]{stdmod_lavaan()}} accepts a \link[lavaan:lavaan-class]{lavaan::lavaan} object, the
structural equation model output returned
by \code{\link[lavaan:lavaan]{lavaan::lavaan()}} and its wrappers (e.g, \code{\link[lavaan:sem]{lavaan::sem()}}) and computes
the standardized moderation effect using the formula in the appendix of
Cheung, Cheung, Lau, Hui, and Vong (2022).

The standard deviations of the focal variable (the variable with its effect
on the outcome variable being moderated), moderator, and outcome
variable (dependent variable) are computed from the implied
covariance matrix returned by
\code{\link[lavaan:lavInspect]{lavaan::lavInspect()}}. Therefore, models fitted to data sets with missing
data (e.g., with \code{missing = "fiml"}) are also supported.

Partial standardization can also be requested. For example, standardization
can be requested for only the focal variable and the outcome variable.

There are two ways to request nonparametric bootstrap
confidence interval. First, the model is fitted with \code{se = "boot"}
or \code{se = "bootstrap"} in \code{lavaan}. The stored bootstrap
estimates will then be retrieved automatically to compute the
standardized moderation effect. This is the most efficient approach
if the bootstrap confidence intervals are also needed for
other parameters in the model. Bootstrapping needs to be
done only once.

Second, bootstrap estimates can be generated by \code{\link[manymome:do_boot]{manymome::do_boot()}}.
The output is then supplied through the argument \code{boot_out}.
Bootstrapping also only needs to be done once. This approach
is appropriate when bootstrapping confidence intervals are
not needed for other model parameters, or another type
of confidence interval is needed when fitting the model.
Please refer to the help page of \code{\link[manymome:do_boot]{manymome::do_boot()}}
on how to use this function.

In both approaches, the standard deviations are also computed
in each bootstrap samples. This ensures that the sampling
variability of the standard deviations is also taken into
account in computing the bootstrap confidence interval of
the standardized moderation effect.
}

\subsection{Note on the differences between the current version (Version 0.2.7.5 or later) and previous versions (0.2.7.4 and before)}{

In older versions, \code{\link[=stdmod_lavaan]{stdmod_lavaan()}} does not allow for
partial standardization. Moreover,
it uses \code{\link[boot:boot]{boot::boot()}} to do the bootstrapping. Even with
the same seed, the results from \code{\link[boot:boot]{boot::boot()}} are not
identical to those of \code{lavaan} with \code{se = "boot"}
because they differ in the way the indices
of resampling are generated. Both approaches are correct,
They just use the generated random numbers differently.
To have results consistent with those from \code{lavaan},
the current version of \code{\link[=stdmod_lavaan]{stdmod_lavaan()}} adopts a
resampling algorithm identical to that of \code{lavaan}.
Last, in older versions, \code{\link[=stdmod_lavaan]{stdmod_lavaan()}} does
bootstrapping every time it is called. This is
inefficient.

The bootstrapping results in the current version are not
identical to those in older versions due to the use
of different resampling algorithms, To reproduce
previous results, set \code{use_old_version} to \code{TRUE}
}
}
\examples{

#Load a test data of 500 cases

dat <- test_mod1
library(lavaan)
mod <-
"
med ~ iv + mod + iv:mod + cov1
dv ~ med + cov2
"

fit <- sem(mod, dat)

# Compute the standardized moderation effect
out_noboot <- stdmod_lavaan(fit = fit,
                            x = "iv",
                            y = "med",
                            w = "mod",
                            x_w = "iv:mod")
out_noboot

# Compute the standardized moderation effect and
# its percentile confidence interval using
# nonparametric bootstrapping
# Fit the model with bootstrap confidence intervals
# At least 2000 bootstrap samples should be used
# in real research. 50 is used here only for
# illustration.
fit <- sem(mod, dat, se = "boot", bootstrap = 50,
           iseed = 89574)
out_boot <- stdmod_lavaan(fit = fit,
                          x = "iv",
                          y = "med",
                          w = "mod",
                          x_w = "iv:mod",
                          boot_ci = TRUE)
out_boot

}
\references{
Cheung, S. F., Cheung, S.-H., Lau, E. Y. Y., Hui, C. H., & Vong, W. N.
(2022) Improving an old way to measure moderation effect in standardized
units. \emph{Health Psychology}, \emph{41}(7), 502-505.
\doi{10.1037/hea0001188}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
