% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_stdmod.R
\name{summary.std_selected}
\alias{summary.std_selected}
\title{Summary Method for a 'std_selected' Class Object}
\usage{
\method{summary}{std_selected}(object, ...)
}
\arguments{
\item{object}{The output of \code{\link[=std_selected]{std_selected()}} or \code{\link[=std_selected_boot]{std_selected_boot()}}.}

\item{...}{Additional arguments. Ignored by this function.}
}
\value{
An object of class \code{summary.std_selected}, with
bootstrap confidence intervals added if present in the object.
The object is a list. Its main element \code{coefficients} is similar to
the
coefficient table in the \code{\link[=summary]{summary()}} printout of \code{\link[=lm]{lm()}}.
This object is for printing summary information of the results
from \code{\link[=std_selected]{std_selected()}} or \code{\link[=std_selected_boot]{std_selected_boot()}}.
}
\description{
Summarize the results of \code{\link[=std_selected]{std_selected()}} or
\code{\link[=std_selected_boot]{std_selected_boot()}}.
}
\examples{

# Load a sample data set

dat <- test_x_1_w_1_v_1_cat1_n_500

# Do a moderated regression by lm
lm_raw <- lm(dv ~ iv*mod + v1 + cat1, dat)
summary(lm_raw)

# Standardize all variables except for categorical variables.
# Interaction terms are formed after standardization.
lm_std <- std_selected(lm_raw, to_scale = ~ .,
                               to_center = ~ .)
summary(lm_std)

# With bootstrapping
# nboot = 100 just for illustration. nboot >= 2000 should be used in read
# research.
lm_std_boot <- std_selected_boot(lm_raw, to_scale = ~ .,
                                         to_center = ~ .,
                                         nboot = 100)
summary(lm_std_boot)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
