% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandit_posterior.R
\name{plot_bandit_posterior}
\alias{plot_bandit_posterior}
\title{plot_bandit_posterior}
\usage{
plot_bandit_posterior(data, prior = c(m1_good = 0.5, m2_good = 0.5),
  win_probs = c(good = 1/2, bad = 1/3))
}
\arguments{
\item{data}{data frame containing win loss data}

\item{prior}{prior vector containing the probabilities of Machine 1 and Machine 2 being good, defaults to 50-50.}

\item{win_probs}{vector containing the probabilities of winning on the good and bad machine respectively.}
}
\description{
Generates a plot that shows the bandit posterior values as they are sequentially updated 
by the provided win / loss data.
}
\examples{
# capture data from the `shiny` app `bandit_sim`.
data = data.frame(machine = c(1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L), 
                  outcome = c("W", "L", "W", "L", "L", "W", "L", "L", "L", "W"))
plot_bandit_posterior(data)

}
\seealso{
\code{\link{bandit_sim}} to generate data to use below
}
