% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.test.mann}
\alias{size.test.mann}
\title{Sample size for a Mann-Whitney test}
\usage{
size.test.mann(alpha, pow, p)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{p}{planning value of Mann-Whitney parameter}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group (assuming equal sample sizes)
required for the Mann-Whitney test with desired power. A planning value
of the Mann-Whitney parameter is required. In a 2-group experiment, this
parameter is the proportion of members in the population with scores that
would be larger under treatment 1 than treatment 2. In a 2-group
nonexperiment where participants are sampled from two subpopulations of
sizes N1 and N2, the parameter is the proportion of all N1 x N2 pairs in
which a member from subpopulation 1 has a larger score than a member from
subpopulation 2.
}
\examples{
size.test.mann(.05, .90, .3)

# Should return:
# Sample size per group
#                    44
 

}
\references{
\insertRef{Noether1987}{statpsych}
}
