% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.test.lc.prop.bs}
\alias{size.test.lc.prop.bs}
\title{Sample size for a test of between-subjects proportion linear contrast}
\usage{
size.test.lc.prop.bs(alpha, pow, p, es, v)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{p}{vector of proportion planning values}

\item{es}{planning value of proportion linear contrast}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns the required sample size per group
}
\description{
Computes the sample size in each group (assuming equal sample sizes) required
to test a linear contrast of population proportions with desired power in a
between-subjects design. This function requires planning values for all
proportions. Set the proportion planning values to .5 for a conservatively
large sample size. The planning value for the effect size (linear contrast of
proportions) could be set equal to the linear contrast of proportion planning
values or it could be set equal to a minimally interesting effect size.
}
\examples{
p <- c(.25, .30, .50, .50)
v <- c(.5, .5, -.5, -.5)
size.test.lc.prop.bs(.05, .9, p, .15, v)

# Should return:
#      Sample size per group
# [1,]                   105


}
