% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.lc.median.bs}
\alias{ci.lc.median.bs}
\title{Confidence interval for a linear contrast of medians in a between-subjects
design}
\usage{
ci.lc.median.bs(alpha, m, se, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{vector of estimated group medians}

\item{se}{vector of group standard errors}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated linear contrast of medians
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a linear contrast of medians in a
between-subjects design using estimated medians and their standard errors.
The sample median and standard error for each group can be computed using
the ci.median1 function.
}
\examples{
m <- c(46.13, 29.19, 30.32, 49.15)
se <- c(6.361, 5.892, 4.887, 6.103)
v <- c(1, -1, -1, 1)
ci.lc.median.bs(.05, m, se, v)

# Should return:
#      Estimate       SE       LL       UL
# [1,]    35.77 11.67507 12.88727 58.65273


}
\references{
\insertRef{Bonett2002}{statpsych}
}
