% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.cor2.gen}
\alias{ci.cor2.gen}
\title{Confidence interval for a 2-group correlation difference}
\usage{
ci.cor2.gen(cor1, ll1, ul1, cor2, ll2, ul2)
}
\arguments{
\item{cor1}{estimated correlation for group 1}

\item{ll1}{lower limit for group 1 correlation}

\item{ul1}{upper limit for group 1 correlation}

\item{cor2}{estimated correlation for group 2}

\item{ll2}{lower limit for group 2 correlation}

\item{ul2}{upper limit for group 2 correlation}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated correlation difference
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a 100(1 - alpha)\% confidence interval for a difference in
population correlations in a 2-group design. The correlations can be
Pearson, Spearman, partial, semipartial, or point-biserial correlations.
The function requires 100(1 - alpha)\% confidence intervals for each
correlation as input. This function also can be used to compute a
confidence interval for the difference of two Cronbach reliability
coefficients.
}
\examples{
ci.cor2.gen(.4, .35, .47, .2, .1, .32)

# Should return:
#      Estimate   LL        UL
# [1,]      0.2 0.07 0.3220656
 

}
\references{
\insertRef{Zou2007}{statpsych}
}
