% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.ci.ratio.prop.ps}
\alias{size.ci.ratio.prop.ps}
\title{Sample size for a paired-samples proportion ratio confidence interval}
\usage{
size.ci.ratio.prop.ps(alpha, p1, p2, phi, r)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{p1}{planning value of proportion for measurement 1}

\item{p2}{planning value of proportion for measurement 2}

\item{phi}{planning value of phi coefficient}

\item{r}{desired upper to lower confidence interval endpoint ratio}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a ratio of proportions
with desired confidence interval precision in a paired-samples design.
Set the phi planning value to the smallest value within a plausible range
for a conservatively large sample size.
}
\examples{
size.ci.ratio.prop.ps(.05, .4, .2, .7, 2)

# Should return:
#      Sample size
# [1,]          67


}
