% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.tukey}
\alias{ci.tukey}
\title{Tukey-Kramer confidence intervals for all pairwise mean differences in a
betwen-subjects design}
\usage{
ci.tukey(alpha, m, sd, n)
}
\arguments{
\item{alpha}{alpha level for simultaneous 1-alpha confidence}

\item{m}{vector of group sample means}

\item{sd}{vector of group sample standard deviations}

\item{n}{vector of sample sizes}
}
\value{
Returns a matrix with the number of rows equal to the number
of pairwise comparisons. The columns are:
\itemize{
\item Estimate - estimated mean difference
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes heteroscedastic Tukey-Kramer (also known as Games-Howell)
confidence intervals for all pairwise comparisons of population means
using sample means, sample standard deviations, and samples sizes as
input. A Satterthwaite adjustment to the degrees of freedom is used to
improve the accuracy of the confidence intervals.
}
\examples{
m <- c(12.86, 17.57, 26.29)
sd <- c(3.185, 3.995, 3.773)
n <- c(20, 20, 20)
ci.tukey(.05, m, sd, n)

# Should return:
#      Estimate       SE          t     p       df         LL         UL
# 1 2     -4.71 1.142459  -4.122686 0.001 36.20303  -7.501842  -1.918158
# 1 3    -13.43 1.104078 -12.163998 0.000 36.95915 -16.125713 -10.734287
# 2 3     -8.72 1.228730  -7.096758 0.000 37.87646 -11.717053  -5.722947


}
\references{
\insertRef{Games1976}{statpsych}
}
