% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\encoding{UTF-8}
\name{sp_get_table}
\alias{sp_get_table}
\title{Get a statnipokladna table}
\usage{
sp_get_table(
  table_id,
  year = 2018,
  month = 12,
  ico = NULL,
  redownload = FALSE,
  dest_dir = tempdir()
)
}
\arguments{
\item{table_id}{A table ID. See \code{id} column in \code{sp_tables} for a list of available codelists.}

\item{year}{year, numeric, 2015-2018 for some datasets, 2010-2018 for others.
Can be a vector of length > 1 (see Details for how to work with data across time periods.).}

\item{month}{month, numeric. Must be 3, 6, 9 or 12. Can be a vector of length > 1 (see details).}

\item{ico}{ID(s) of org to return, character of length one or more. If unset, returns all orgs. ID not checked for correctness/existence. See \url{http://monitor.statnipokladna.cz/datovy-katalog/prohlizec-ciselniku/ucjed} to look up ID of any org in the dataset.}

\item{redownload}{Redownload even if recent file present? Defaults to FALSE.}

\item{dest_dir}{character. Directory in which downloaded files will be stored. Defaults to \code{tempdir()}. Will be created if it does not exist.}
}
\value{
a tibble; see Details for key to the columns
}
\description{
Cleans and loads a table. If needed, a dataset containing the table is downloaded.
}
\details{
The data is loaded from files downloaded automatically by \code{sp_get_dataset()};
files persist in a temporary directory per session.

How data for different time periods is exported differs by dataset.
This has significant implications for how you get to usable full-year numbers or time series in different tables.
See \code{vignette("statnipokladna")} for details on this.

Data is processed in the following way:
\itemize{
\item all columns are given names that are human-readable and facilitato add codelists
\item ICO (org. IDs) are normalised as in some datasets they are padded with leading zeros
\item a period, per_yr and per_m columns are created to identify the time period
\item value columns are transformed into numeric
\item other columns are left as character to avoid losing information
}
\subsection{Correspondence between input and output columns}{

\strong{Shared}\tabular{lllll}{
   Original \tab Output \tab English \tab Czech \tab Note \cr
   ZC_VTAB \tab vtab \tab table number \tab tabulka \tab - \cr
   ZC_UCJED \tab ucjed \tab accounting unit \tab účetní jednotka \tab NB: ucjed != ico; the two codes are different; ICO is universal, ucjed is specific to SP, and both denote an organisation. \cr
   ZC_VYKAZ \tab vykaz \tab report number \tab výkaz \tab - \cr
   ZFUNDS_CT \tab finmisto \tab accounting centre \tab finanční místo \tab either kapitola or "organizační složka státu" (core state org) \cr
   ZC_ICO \tab ico \tab org ID \tab IČO \tab see ucjed \cr
   ZC_FUND \tab zdroj \tab funding source \tab zdroj \tab - \cr
   ZC_KRAJ \tab kraj \tab region \tab kraj \tab - \cr
   ZC_NUTS \tab nuts \tab NUTS code \tab NUTS kód \tab - \cr
}


\strong{Tables \verb{budget-*}}\tabular{lllll}{
   Original \tab Output \tab English \tab Czech \tab Note \cr
   ZCMMT_ITM \tab polozka \tab item/line \tab položka (druhové členění) \tab NB: polozka != polvyk \cr
   0FM_AREA \tab kapitola \tab chapter \tab kapitola \tab - \cr
   FUNC0AREA \tab paragraf \tab sector line \tab paragraf (odvětvové členění) \tab - \cr
   0FUNC_AREA \tab paragraf \tab sector line \tab paragraf (odvětvové členění) \tab - \cr
   ZU_ROZSCH \tab budget_adopted \tab budget as originally adopted \tab schválený rozpočet \tab - \cr
   ZU_ROZPZM \tab budget_amended \tab budget as amended throughout the year \tab rozpočet po změnách \tab - \cr
   ZU_KROZP \tab budget_final \tab final budget \tab konečný rozpočet \tab - \cr
   ZU_ROZKZ \tab budget_spending \tab actual spending \tab skutečnost \tab - \cr
}


\strong{Tables \verb{balance-sheet*}}\tabular{lllll}{
   Original \tab Output \tab English \tab Czech \tab Note \cr
   ZC_POLVYK \tab polvyk \tab item/line \tab položka výkazu \tab - \cr
   ZU_MONET \tab previous_net \tab net, previous period \tab netto minulé období \tab - \cr
   ZU_AOBTTO \tab current_gross \tab gross, current period \tab brutto běžné období \tab - \cr
   ZU_AONET \tab current_net \tab net, current period \tab netto běžné období \tab - \cr
   ZU_AOKORR \tab current_correction \tab correction, current period \tab korekce běžné období \tab - \cr
}


\strong{Tables \verb{profit-and-loss-*}}\tabular{lllll}{
   Original \tab Output \tab English \tab Czech \tab Note \cr
   ZU_HLCIN \tab previous_core \tab core activity, previous period \tab hlavní činnost, minulé období \tab - \cr
   ZU_HOSCIN \tab previous_economic \tab economic activity, previous period \tab hospodářská činnost, minulé období \tab - \cr
   ZU_HLCIBO \tab current_core \tab core activity, current period \tab hlavní činnost, běžné období \tab - \cr
   ZU_HCINBO \tab current_economic \tab economic activity, current period \tab hospodářská činnost, běžné období \tab - \cr
}


\strong{Table \verb{changes-in-equity}}\tabular{lllll}{
   Original \tab Output \tab English \tab Czech \tab Note \cr
   ZU_STAVP \tab before \tab previous period \tab stav minulé období \tab - \cr
   ZU_STAVPO \tab after \tab current period \tab stav běžné období \tab - \cr
   ZU_ZVYS \tab increase \tab increase \tab zvýšení stavu \tab - \cr
   ZU_SNIZ \tab decrease \tab decrease \tab snížení stavu \tab - \cr
}


\strong{Table \code{cash-flow}}\tabular{lllll}{
   Original \tab Output \tab English \tab Czech \tab Note \cr
   ZU_BEZUO \tab current \tab current period \tab běžné účetní období \tab - \cr
}

}
}
\examples{
\donttest{
allorgs_latest <- sp_get_table("budget-local")
allorgs_2018 <- sp_get_table("budget-local", 2018)
allorgs_mid2018 <- sp_get_table("budget-local", 2018, 6)
oneorg_multiyear <- sp_get_table("budget-local", 2012:2018, 12, ico = "00064581")
oneorg_multihalfyears <- sp_get_table("budget-local", 2013:2018, c(6, 12), ico = "00064581")
}
}
\seealso{
Other Core workflow: 
\code{\link{add_codelist}()},
\code{\link{get_codelist}()},
\code{\link{sp_add_codelist}()},
\code{\link{sp_get_codelist}()},
\code{\link{sp_get_dataset}()}
}
\concept{Core workflow}
