% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/chaotic_maps.R
\name{skew_tent_map}
\alias{skew_tent_map}
\title{A function to generate a time series from the logistic map}
\usage{
skew_tent_map(N, a, start="rand", disregard_N=0)
}
\arguments{
\item{N}{length of the time series that is to be generated}

\item{a}{Skew-Tent map parameter, must be in the range [0,1]}

\item{start}{start value. Default is to random.}

\item{disregard_N}{Number of values at the beginning of the series to disregard}
}
\value{
A vector of length N
}
\description{
Generates a time series from the Skew-Tent map
}
\examples{
skew_tent_map(N = 10^4, a=0.1847)
}
\author{
Sebastian Sippel
}
\references{
Schuster, H.G., 1988. Deterministic chaos. An Introduction.
}

