% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/complexity_measures.R
\name{global_complexity}
\alias{global_complexity}
\title{A function to compute global information and complexity measures for time series}
\usage{
global_complexity(x = NA, opd = NA, ndemb)
}
\arguments{
\item{x}{(OPTIONAL) If opd is not specified, a time series vector x must be specified}

\item{opd}{A numeric vector that details an ordinal pattern distribution in a user-specified permutation coding scheme.}

\item{ndemb}{(OPTIONAL) If x is given, the embedding dimension (ndemb) is required.}
}
\value{
A named vector containing the three global complexity measures.
}
\description{
This is a high-level function that calculates global complexity measures directly from a given time series or ordinal pattern distribution.
}
\details{
This function calculates the following global measures of complexity and information:
\itemize{
 \item Permutation Entropy (PE, cf. Bandt and Pompe, 2002)
 \item Permutation Statistical complexity (MPR complexity, cf. Martin, Plastino and Rosso, 2006)
 \item Number of "forbiden patterns" (cf. Amigo 2010)
}
}
\examples{
x = arima.sim(model=list(ar = 0.3), n = 10^4)
global_complexity(x = x, ndemb = 6)
# or:
opd = ordinal_pattern_distribution(x = x, ndemb = 6)
global_complexity(opd = opd, ndemb = 6)
}
\author{
Sebastian Sippel
}
\references{
Bandt, C. and Pompe, B., 2002. Permutation entropy: a natural complexity measure for time series. Physical review letters, 88(17), p.174102.
Martin, M.T., Plastino, A. and Rosso, O.A., 2006. Generalized statistical complexity measures: Geometrical and analytical properties. Physica A: Statistical Mechanics and its Applications, 369(2), pp.439-462.
Amigo, J., 2010. Permutation complexity in dynamical systems: ordinal patterns, permutation entropy and all that. Springer Science & Business Media.
}

