% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/complexity_measures.R
\name{fis}
\alias{fis}
\title{A (low-level) function to compute the Fisher-information}
\usage{
fis(opd, discretization)
}
\arguments{
\item{opd}{A numeric vector that details an ordinal pattern distribution in a user-specified permutation coding scheme.}

\item{discretization}{The discretization scheme to use, either 'Olivares.2012' or 'Ferri.2009'}
}
\value{
The normalized Fisher information measure in the range [0, 1].
}
\description{
The function computes the Fisher information, i.e. a local information measure based on two different discretizations.
}
\details{
The Fisher information is a local information and complexity measure, computed based on the ordinal pattern distribution.
The Fisher information is based on local gradients, hence it is sensitive to the permutation coding scheme.
Options for discretization: 'Olivares.2012' or 'Ferri.2009', following Fisher Information discretization schemes in the respective publications.
}
\examples{
x = arima.sim(model=list(ar = 0.3), n = 10^4)
opd = ordinal_pattern_distribution(x = x, ndemb = 6)
fis(opd = opd)
}
\author{
Sebastian Sippel
}
\references{
Olivares, F., Plastino, A. and Rosso, O.A., 2012. Ambiguities in Bandt-Pompe's methodology for local entropic quantifiers. Physica A: Statistical Mechanics and its Applications, 391(8), pp.2518-2526.
Ferri, G.L., Pennini, F. and Plastino, A., 2009. LMC-complexity and various chaotic regimes. Physics Letters A, 373(26), pp.2210-2214.
}

