% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{graph.entropy}
\alias{graph.entropy}
\title{Graph spectral entropy}
\usage{
graph.entropy(A = NULL, bandwidth = "Silverman", eigenvalues = NULL)
}
\arguments{
\item{A}{the adjacency matrix of the graph. For an unweighted graph, it
contains only 0s and 1s. For a weighted graph, it may contain nonnegative
real numbers that correspond to the weights of the edges.}

\item{bandwidth}{string showing which criterion is used to choose the
bandwidth during the spectral density estimation. Choose between the
following criteria: "Silverman" (default), "Sturges" and "bcv".
"bcv" is an abbreviation of biased cross-validation.}

\item{eigenvalues}{optional parameter. It contains the eigenvalues of matrix
A. Then, if the eigenvalues of matrix A have already been computed, this
parameter can be used instead of A. If no value is passed, then the
eigenvalues of A will be computed by 'graph.entropy'.}
}
\value{
a real number corresponding to the graph spectral entropy.
}
\description{
\code{graph.entropy} returns the spectral entropy of an undirected graph.
}
\examples{
G <- igraph::sample_gnp(n=100, p=0.5)
A <- as.matrix(igraph::get.adjacency(G))
entropy <- graph.entropy(A)
entropy

}
\references{
Takahashi, D. Y., Sato, J. R., Ferreira, C. E. and Fujita A. (2012)
Discriminating Different Classes of Biological Networks by Analyzing the
Graph Spectra  Distribution. _PLoS ONE_, *7*, e49949.
doi:10.1371/journal.pone.0049949.

Silverman, B. W. (1986) _Density Estimation_.  London: Chapman and Hall.

Sturges, H. A. The Choice of a Class Interval. _J. Am. Statist. Assoc._,
*21*, 65-66.
}
\keyword{spectral_entropy}
