% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{kmeans.graph}
\alias{kmeans.graph}
\title{K-means for Graphs}
\usage{
kmeans.graph(x, k, nstart = 2)
}
\arguments{
\item{x}{a list containing the adjacency matrix of the graphs to be
clustered.}

\item{k}{an integer specifying the number of clusters.}

\item{nstart}{the number of trials of k-means clusterizations. The algorithm
returns the clusterization with the best silhouette.}
}
\value{
a vector of the same length of g containing the clusterization
labels.
}
\description{
\code{kmeans.graph} clusters graphs following a k-means algorithm based on
the Jensen-Shannon divergence between the spectral densities of the graphs.
}
\examples{
x <- list()
for(i in 1:5){
  x[[i]] <- igraph::get.adjacency(igraph::sample_gnp(30, p=0.2))
}
for(i in 6:10){
  x[[i]] <- igraph::get.adjacency(igraph::sample_gnp(30, p=0.5))
}
res <- kmeans.graph(x, k=2, nstart=2)
res

}
\references{
MacQueen, James. "Some methods for classification and analysis of
multivariate observations." Proceedings of the fifth Berkeley symposium on
mathematical statistics and probability. Vol. 1. No. 14. 1967.

Lloyd, Stuart. "Least squares quantization in PCM." IEEE transactions on
information theory 28.2 (1982): 129-137.
}
\keyword{k-means}
