% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsubfactorial.R
\name{lsubfactorial}
\alias{lsubfactorial}
\title{Logarithm of the subfactorial numbers}
\usage{
lsubfactorial(x)
}
\arguments{
\item{x}{A vector of non-negative integers}
}
\value{
If the input is a vector of non-negative integers, the output will be a vector of the logarithms of
the corresponding subfactorial numbers.
}
\description{
\code{lsubfactorial} returns the logarithms of the subfactorial numbers.
}
\details{
The subfactorial numbers count the number of derangements of a set of objects (permutations in which no element
appears in its original position).  This function computes the logarithms of the subfactorial numbers for a given
input vector specifying the numbers of interest.
}
\examples{
# In the limit n! / !n goes to e
# so limit of differences of logs is 1
lfactorial(1000) - lsubfactorial(1000)


}
