% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_symlink.R
\name{create_symlink}
\alias{create_symlink}
\title{Establish symbolic link between folders}
\usage{
create_symlink(to, name = "secure_data", ...)
}
\arguments{
\item{to}{target file or directory to which the shortcut should point to.}

\item{name}{symbolic link folder name. Default folder name is `"secure_data"``}

\item{...}{
  Arguments passed on to \code{\link[R.utils:createLink]{R.utils::createLink}}
  \describe{
    \item{\code{}}{}
  }}
}
\value{
NULL, Places the path or pathname to the link.
}
\description{
The \code{starter_symlink()} function is an OS agnostic function that creates symbolic
links between two folders. The function is, at its core, a wrapper for the
\code{R.utils::createLink()} function with opinionated
defaults. The function must be called in an environment where the working
directory is known (e.g. using \verb{*.Rproj}, \code{setwd()}, etc.).
}
\details{
A symbolic link is a special kind of file that points to another file/folder.
A symbolic link does not contain the data in the target file. It simply points
to another entry somewhere in the file system. This allows symbolic links
to link to directories or files on remote network locations. Depending
on your operating system, a link may not establish if the originating
path is a network drive.
}
\examples{
# only run fn interactively, will place symbolic link in current working dir
if (interactive()) {
  # Using `starter_symlink()` to establish a symbolic link to a
  # mapped networked data folder.
  # The default name of the symlink folder is 'secure_data'
  create_symlink("O:/Outcomes/Project Folder/Data")
}
}
\seealso{
\code{\link[R.utils:createLink]{R.utils::createLink()}}
}
\author{
Daniel D. Sjoberg
}
