% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_project.R
\name{create_project}
\alias{create_project}
\title{Start a new project}
\usage{
create_project(
  path,
  path_data = NULL,
  template = "default",
  git = TRUE,
  renv = TRUE,
  symlink = git,
  renv.settings = NULL,
  overwrite = NA,
  open = interactive()
)
}
\arguments{
\item{path}{A path. If it exists, it is used. If it does not exist, it is
created.}

\item{path_data}{A path. The directory where the secure data exist. Default is
\code{NULL}.  When supplied, a symbolic link to data folder will be created.}

\item{template}{A project template. See
\href{https://www.danieldsjoberg.com/starter/articles/create_project.html}{vignette}
for details.}

\item{git}{Logical indicating whether to create Git repository.  Default is \code{TRUE}
When \code{NA}, user will be prompted whether to initialise Git repo.}

\item{renv}{Logical indicating whether to add renv to a project.
Default is \code{TRUE}. When \code{NA} user is asked interactively for preference.}

\item{symlink}{Logical indicating whether to place a symbolic link
to the location in \verb{path_data=}. Default is to place the symbolic link
if the project is a git repository.}

\item{renv.settings}{A list of renv settings passed to \code{renv::scaffold(settings=)}}

\item{overwrite}{Logical indicating whether to overwrite existing files
if they exist.  Options are
\code{TRUE}, \code{FALSE}, and \code{NA} (aka ask interactively).  Default is \code{NA}}

\item{open}{Logical indicating whether to open new project in fresh RStudio
session}
}
\value{
NULL, places project template in new or existing directory
}
\description{
Creates a directory with the essential files for
a new project. The function can be used on existing project directories as well.
Existing files will \emph{not} be overwritten; rather, the user will be prompted
whether to replace the existing file with the template file.
}
\section{Personalized Template}{

Users can create a
personalized project template. Check out the
\href{https://www.danieldsjoberg.com/starter/articles/create_project.html}{vignette}
for step by step instructions.
}

\examples{
\dontshow{if (pkgdown::in_pkgdown()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# specifying project folder location (folder does not yet exist)
project_path <- fs::path(tempdir(), "My Project Folder")

# creating folder where secure data would be stored (typically will be a network drive)
secure_data_path <- fs::path(tempdir(), "secure_data")
fs::dir_create(secure_data_path)

# creating new project folder
create_project(project_path, path_data = secure_data_path)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=use_project_file]{use_project_file()}}

\href{https://www.danieldsjoberg.com/starter/articles/create_project.html}{Vignette for \code{create_project()}}
}
\author{
Daniel D. Sjoberg
}
