% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_pdf.R
\name{set_fields}
\alias{set_fields}
\title{Set fields of a pdf form}
\usage{
set_fields(
  input_filepath = NULL,
  output_filepath = NULL,
  fields,
  overwrite = TRUE,
  convert_field_names = FALSE,
  flatten = FALSE
)
}
\arguments{
\item{input_filepath}{the path of the input PDF file. The default is set to
NULL. IF NULL, it  prompt the user to select the folder interactively.}

\item{output_filepath}{the path of the output PDF file. The default is set to
NULL. IF NULL, it  prompt the user to select the folder interactively.}

\item{fields}{Fields returned from \code{\link{get_fields}} function. To make
changes in a PDF, edit the \code{values} component of an element within
this list}

\item{overwrite}{If a file exists in \code{output_filepath}, should it be overwritten.}

\item{convert_field_names}{If you set convert_field_names when using \code{\link{get_fields}}
you should set this to TRUE as well so the fields can be matched correctly.}

\item{flatten}{If TRUE, the form fields will be flattened and turned into plain text.}
}
\description{
If the toolkit Pdftk is available in the
system, it will be called to fill a pdf form with given a list of fields.
List of fields can be acquired by \code{\link{get_fields}} function.

See the reference for detailed usage of \code{pdftk}.
}
\examples{
\dontrun{
pdfFile = system.file('testForm.pdf',package = 'staplr')
fields = get_fields(pdfFile)

fields$TextField1$value = 'this is text'
fields$TextField2$value = 'more text'
fields$RadioGroup$value = 2
fields$checkBox$value = 'Yes'

set_fields(pdfFile,'filledPdf.pdf',fields)
}

}
\references{
\url{https://www.pdflabs.com/tools/pdftk-the-pdf-toolkit/}
}
\seealso{
\code{\link{get_fields}}
}
\author{
Ogan Mancarci
}
