% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_pdf.R
\name{set_fields}
\alias{set_fields}
\title{Set fields of a pdf form}
\usage{
set_fields(input_filepath = NULL, output_filepath = NULL, fields)
}
\arguments{
\item{input_filepath}{the path of the input PDF file. The default is set to
NULL. IF NULL, it  prompt the user to select the folder interactively.}

\item{output_filepath}{the path of the output PDF file. The default is set to
NULL. IF NULL, it  prompt the user to select the folder interactively.}

\item{fields}{Fields returned from \code{\link{get_fields}} function. To make
changes in a PDF, edit the \code{values} component of an element within
this list}
}
\description{
Set fields of a pdf form
}
\examples{
\dontrun{
pdfFile = system.file('testForm.pdf',package = 'staplr')
fields = get_fields(pdfFile)

fields$TextField1$value = 'this is text'
fields$TextField2$value = 'more text'
fields$RadioGroup$value = 2
fields$checkBox$value = 'Yes'

set_fields(pdfFile,'filledPdf.pdf',fields)
}

}
\seealso{
\code{\link{get_fields}}
}
\author{
Ogan Mancarci
}
