% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1b-base-model-function.R
\name{sevt_fit}
\alias{sevt_fit}
\title{Fit a staged event tree}
\usage{
sevt_fit(object, data = NULL, lambda = object$lambda)
}
\arguments{
\item{object}{an object of class \code{sevt}.}

\item{data}{data.frame or contingency table with observations of
the variables in \code{object}.}

\item{lambda}{smoothing parameter or pseudocount.}
}
\value{
A fitted staged event tree, that is an object of class \code{sevt}
with \code{ctables}, \code{prob} and \code{ll} components.
}
\description{
Estimate transition probabilities in a staged event tree from data.
Probabilities are estimated with the relative frequencies plus,
eventually, an additive (Laplace) smoothing.
}
\details{
The data in form of contingency tables and the
log-likelihood of the model is
stored in the returned staged event tree.
}
\examples{

#########
model <- sevt(list(
  X = c("good", "bad"),
  Y = c("high", "low")
))
D <- data.frame(
  X = c("good", "good", "bad"),
  Y = c("high", "low", "low")
)
model.fit <- sevt_fit(model, data = D, lambda = 1)
}
