% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stagedtrees.R
\docType{package}
\name{stagedtrees}
\alias{stagedtrees}
\alias{stagedtrees-package}
\title{Staged event trees.}
\description{
Algorithms to create, learn, fit and explore staged event tree models.
Functions to compute probabilities and make predictions from the fitted
models and to plot, analyze and manipulate staged event trees.
}
\details{
Model selection algorithms:
\itemize{
\item full model \code{\link{full}}
\item independence model \code{\link{indep}}
\item Hill-Climbing \code{\link{hc.sevt}}
\item Backward Hill-Climbing \code{\link{bhc.sevt}}
\item Fast Backward Hill-Climbing \code{\link{fbhc.sevt}}
\item Backward Hill-Climbing Random \code{\link{bhcr.sevt}}
\item Backward joining \code{\link{bj.sevt}}
\item Naive Staged Event Tree \code{\link{naive.sevt}}
}

Probabilities, log-likelihood and predictions:
\itemize{
\item Marginal probabilities \code{\link{prob.sevt}}
\item Log-Likelihood \code{\link{logLik.sevt}}
\item Predict method \code{\link{predict.sevt}}
}

Plot, explore and compare:
\itemize{
\item Plot \code{\link{plot.sevt}}
\item Compare \code{\link{compare.sevt}}
\item Stages info \code{\link{stages.sevt}}, \code{\link{summary.sevt}}
}
}
\examples{
data("PhDArticles")
mf <- full(PhDArticles)
mod <- fbhc.sevt(mf)
plot(mod)

}
\references{
Collazo R. A., Görgen C. and Smith J. Q.
Chain event graphs. CRC Press, 2018.

Görgen C., Bigatti A., Riccomagno E. and Smith J. Q.
Discovery of statistical equivalence classes using computer algebra.
\emph{International Journal of Approximate Reasoning}, vol. 95, pp. 167-184, 2018.

Barclay L. M., Hutton J. L. and Smith J. Q.
Refining a Bayesian network using a chain event graph.
\emph{International Journal of Approximate Reasoning}, vol. 54, pp. 1300-1309, 2013.

Smith J. Q. and Anderson P. E.
Conditional independence and chain event graphs.
\emph{Artificial Intelligence}, vol. 172, pp. 42-68, 2008.

Thwaites P. A., Smith, J. Q.
A new method for tackling asymmetric decision problems.
\emph{International Journal of Approximate Reasoning}, vol. 88, pp. 624–639, 2017.
}
