% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_mig_mult.R
\name{calcule,report_mig_mult-method}
\alias{calcule,report_mig_mult-method}
\alias{calcule.report_mig_mult}
\title{#' Transforms migration per period to daily migrations, and performs the conversion from weights to number is data
are stored as weights (glass eel). This calculation is performed in a loop for all dc.}
\usage{
\S4method{calcule}{report_mig_mult}(object, negative = FALSE, silent = FALSE)
}
\arguments{
\item{object}{An object of class \link{report_mig_mult-class}}

\item{negative}{a boolean indicating if a separate sum must be done for positive and negative values, if true, positive and negative counts return 
different rows}

\item{silent}{Default FALSE, should messages be stopped}
}
\value{
report_mig_mult with a list in slot calcdata. For each dc one will find a list with the following elements
\describe{
\item{method}{In the case of instantaneous periods (video counting) the sum of daily values is done by the \link{fun_report_mig_mult} method and the value indicated in method is 'sum'.
 If any migration monitoring period is longer than a day, then the migration is split using the \link{fun_report_mig_mult_overlaps} function and the value indicated in the 
method is 'overlaps' as the latter method uses the overlap package to split migration period.}
\item{data}{the calculated data. If weight are present, the columns display weight or numbers, the total number is 
'Effectif_total' and corresponds to the addition of numbers and numbers converted from weight,
the total weight is 'Poids_total'+'poids_depuis_effectifs' and corresponds to weighed glass eel plus glass eel number converted in weights.
CALCULE corresponds to calulated number, MESURE to measured numbers, EXPERT to punctual expertise of migration (for instance measured in other path, or known migration
of fishes passing the dam but not actually counted, PONCTUEL to fishes counted by visual identification but not by the counting apparatus (in case of technical problem for instance)}
\item{contient_poids}{A boolean which indicates, in the case of glass eel, that the function \link{fun_weight_conversion} has been run to convert the weights to numbers using the weight
to number coefficients in the database (see \link{report_ge_weight}).}
\item{negative}{A parameter indicating if negative migration (downstream in the case of upstream migration devices) have been converted to positive numbers,
not developed yet}}
}
\description{
The calculation must be launched once data are filled by the connect method. Currently the negative argument
has no effect.
}
\note{
The class does not handle escapement rates, though structurally those are present in the database. If you 
want to use those you will have to do the calculation manually from the data in \code{report_mig_mult@data}.
}
