% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_dc.R
\docType{methods}
\name{choicemult,ref_dc-method}
\alias{choicemult,ref_dc-method}
\title{choicemult, selection method for ref_dc allowing to select several DC}
\usage{
\S4method{choicemult}{ref_dc}(object, objectreport = NULL,
  is.enabled = TRUE)
}
\arguments{
\item{object}{An object of class ref_dc}

\item{objectreport}{A report object}

\item{is.enabled}{A boolean indicating if the widget can be seleted at launch}
}
\description{
choicemult, selection method for ref_dc allowing to select several DC
}
\note{
The choice method has for arguments a report (report) object
 (e.g) is called from a report report(e.g report_sample_char).
  By default,  the value of the objectreport is null.
  When it is not   the method calls daughter widgets (e.g. the dc widget will call species) 
and fills it with the method \link{charge_with_filter,ref_taxa-method}
}
\examples{
\dontrun{ 
win=gwindow()
group=ggroup(container=win,horizontal=FALSE)
object=new("ref_dc")
object<-charge(object)
objectreport=new("report_mig_mult")
choicemult(object=object,objectreport=objectreport)
}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}

