% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_dc.R
\docType{methods}
\name{choice,ref_dc-method}
\alias{choice,ref_dc-method}
\title{Graphical method to choose a fishway through the interface}
\usage{
\S4method{choice}{ref_dc}(object, objectreport = NULL, is.enabled = TRUE)
}
\arguments{
\item{object}{An object of class \link{ref_dc-class}}

\item{objectreport}{the objectreport from which this frame was called}

\item{is.enabled}{a boolean indicating whether the current frame will be enabled. Selecting a "parent"
frame may cause some frame to be disabled. When created the frame is enabled.}
}
\description{
Graphical method to choose a fishway through the interface
}
\note{
The choice method has for arguments a report (report) object
 (e.g) is called from a report report(e.g report_sample_char).
  By default,  the value of the objectreport is null.
  When it is not   the method calls daughter widgets (e.g. the dc widget will call species) 
and fills it with the method \link{charge_with_filter,ref_taxa-method}
}
\examples{
\dontrun{ 
win=gwindow()
group=ggroup(container=win,horizontal=FALSE)
object=new("ref_dc")
object<-charge(object)
objectreport=new("report_mig")
choice(object=object,objectreport=objectreport)
}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
\keyword{internal}

