% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation_stability.R
\name{uncorrectedDocumentation}
\alias{uncorrectedDocumentation}
\title{Uncorrected Stability Measures}
\arguments{
\item{p}{\code{numeric(1)}\cr
Total number of features in the datasets.
Required, if \code{correction.for.chance} is set to "estimate" or "exact".}

\item{correction.for.chance}{\code{character(1)}\cr
Should a correction for chance be applied? Correction for chance means that if
features are chosen at random, the expected value must be independent of the number
of chosen features. To correct for chance, the original score is transformed by
\eqn{(score - expected) / (maximum - expected)}. For stability measures whose
score is the average value of pairwise scores, this transformation
is done for all components individually.
Options are "none", "estimate" and "exact".
For "none", no correction is performed, i.e. the original score is used.
For "estimate", \code{N} random feature sets of the same sizes as the input
feature sets (\code{features}) are generated.
For "exact", all possible combinations of feature sets of the same
sizes as the input feature sets are used. Computation is only feasible for very
small numbers of features (\code{p}) and numbers of considered datasets
(\code{length(features)}).}
}
\description{
Uncorrected Stability Measures
}
\keyword{internal}
