% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_functions_adjusted.R
\encoding{UTF-8}
\name{stabilityZucknick}
\alias{stabilityZucknick}
\title{Stability Measure Zucknick}
\usage{
stabilityZucknick(features, sim.mat, threshold = 0.9,
  correction.for.chance = "none", N = 10000, impute.na = NULL)
}
\arguments{
\item{features}{\code{list (length >= 2)}\cr
Chosen features per dataset. Each element of the list contains the features for one dataset.
The features must be given by their names (\code{character}) or indices (\code{integerish}).}

\item{sim.mat}{\code{numeric matrix}\cr
Similarity matrix which contains the similarity structure of all features based on
all datasets. The similarity values must be in the range of [0, 1] where 0 indicates
very low similarity and 1 indicates very high similarity. If the list elements of
\code{features} are integerish vectors, then the feature numbering must correspond to the
ordering of \code{sim.mat}. If the list elements of \code{features} are character
vectors, then \code{sim.mat} must be named and the names of \code{sim.mat} must correspond
to the entries in \code{features}.}

\item{threshold}{\code{numeric(1)}\cr
Threshold for indicating which features are similar and which are not. Two features
are considered as similar, if and only if the corresponding entry of \code{sim.mat} is greater
than or equal to \code{threshold}.}

\item{correction.for.chance}{\code{character(1)}\cr
Should a correction for chance be applied? Correction for chance means that if
features are chosen at random, the expected value must be independent of the number
of chosen features. To correct for chance, the original score is transformed by
\eqn{(score - expected) / (maximum - expected)}. For stability measures whose
score is the average value of pairwise scores, this transformation
is done for all components individually.
Options are "none", "estimate" and "exact".
For "none", no correction is performed, i.e. the original score is used.
For "estimate", \code{N} random feature sets of the same sizes as the input
feature sets (\code{features}) are generated.
For "exact", all possible combinations of feature sets of the same
sizes as the input feature sets are used. Computation is only feasible for very
small numbers of features (\code{p}) and numbers of considered datasets
(\code{length(features)}).}

\item{N}{\code{numeric(1)}\cr
Number of random feature sets to consider. Only relevant if \code{correction.for.chance}
is set to "estimate".}

\item{impute.na}{\code{numeric(1)}\cr
In some scenarios, the stability cannot be assessed based on all feature sets.
E.g. if some of the feature sets are empty, the respective pairwise comparisons yield NA as result.
With which value should these missing values be imputed? \code{NULL} means no imputation.}
}
\value{
\code{numeric(1)} Stability value.
}
\description{
The stability of feature selection is defined as the robustness of
the sets of selected features with respect to small variations in the data on which the
feature selection is conducted. To quantify stability, several datasets from the
same data generating process can be used. Alternatively, a single dataset can be
split into parts by resampling. Either way, all datasets used for feature selection must
contain exactly the same features. The feature selection method of interest is
applied on all of the datasets and the sets of chosen features are recorded.
The stability of the feature selection is assessed based on the sets of chosen features
using stability measures.
}
\details{
The stability measure is defined as
\deqn{\frac{2}{m(m-1)}\sum_{i=1}^{m-1} \sum_{j=i+1}^{m}
\frac{|V_i \cap V_j| + C(V_i, V_j) + C(V_j, V_i)}{|V_i \cup V_j|}} with
\deqn{C(V_k, V_l) = \frac{1}{|V_l|} \sum_{(x, y) \in V_k \times (V_l \backslash V_k) \ with \
Similarity(x,y) \geq threshold} Similarity(x,y).}
Note that this definition slightly differs from its original in order to make it suitable
for arbitrary similarity measures.
}
\section{Notation}{
 For the definition of all stability measures in this package,
the following notation is used:
Let \eqn{V_1, \ldots, V_m} denote the sets of chosen features
for the \eqn{m} datasets, i.e. \code{features} has length \eqn{m} and
\eqn{V_i} is a set which contains the \eqn{i}-th entry of \code{features}.
Furthermore, let \eqn{h_j} denote the number of sets that contain feature
\eqn{X_j} so that \eqn{h_j} is the absolute frequency with which feature \eqn{X_j}
is chosen.
Also, let \eqn{q = \sum_{j=1}^p h_j = \sum_{i=1}^m |V_i|} and \eqn{V = \bigcup_{i=1}^m V_i}.
}

\examples{
feats = list(1:3, 1:4, 1:5)
mat = 0.92 ^ abs(outer(1:10, 1:10, "-"))
stabilityZucknick(features = feats, sim.mat = mat)
}
\references{
\itemize{
\item M. Zucknick, S. Richardson, and E. Stronach, "Comparing the
characteristics of gene expression profiles derived by univariate
andmultivariate classification methods", Statistical Applications
in Genetics and Molecular Biology, vol. 7, no. 1, pp. 1-34, 2008.
\item A. Bommert, J. Rahnenführer, and M. Lang,
"A multi-criteria approach to find predictive and sparse models with
stable feature selection for high-dimensional data",
Computational and mathematical methods in medicine, 2017.
}
}
\seealso{
\link{listStabilityMeasures}
}
