% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio-base.R
\name{portfolio}
\alias{portfolio}
\title{Constructing a SST Portfolio}
\usage{
portfolio(market.items = NULL, participation.item = NULL,
  life.item = NULL, health.item = NULL, base.currency, portfolio.parameters)
}
\arguments{
\item{market.items}{a list of marketItem S3 objects created using the
constructors (see the corresponding help pages for more information):
\itemize{
  \item \code{asset}
  \item \code{cashflow}
  \item \code{liability}
  \item \code{assetForward}
  \item \code{fxForward}
  \item \code{delta}
}
Please refer to the note Section for extra-information.}

\item{participation.item}{a participation S3 object created using the
constructor \code{participation}. This should be expressed in the same currency as \code{base.currency}.}

\item{life.item}{a life S3 object created using the constructor \code{life}. The life
sensitivities be expressed in the same currency as \code{base.currency}.}

\item{health.item}{a health S3 object created using the constructor \code{health}. The health
sensitivities be expressed in the same currency as \code{base.currency}.}

\item{base.currency}{a character value representing the base currency in which the holder of
the portfolio reports its results.}

\item{portfolio.parameters}{a list of parameters specific to the portfolio (understood in currency \code{base.currency}) with entries:
\itemize{
  \item \code{mvm}: market value margin information (MVM), this should be a named list with
    three numeric fields of length one:
    \itemize{
      \item \code{mvm.life}: the market value margin for life;
      \item \code{mvm.health}: the market value margin for health;
      \item \code{mvm.nonlife}: the market value margin for non-life.
    }
  \item \code{rtkr}: risk-bearing capital (RBC) at time 0 run-off, this should be a numeric value of length one.
  \item \code{rtkg}: risk-bearing capital (RBC) at time 0 on-going concern, this should be a numeric value of length one.
  \item \code{credit.risk} the credit risk value, this should be a numeric value of length one.
  \item \code{expected.insurance.result} expected insurance result, this should be a numeric value of length one.
  \item \code{expected.financial.result} expected financial result, this should be a numeric value of length one.
  \item \code{correction.term} correction term, this should be a numeric value of length one.
}}
}
\description{
Constructor for the S3 class portfolio. It allows to build for a sst portfolio
  containing financial items (market items), insurance items (life and health) as well as a participation.
}
\note{
In order to create an \code{sstModel}, the portfolio should contain
  at least one marketItem. Additionally, we do not allow for a portfolio
  containing a participation without any marketItem.
}
\examples{
# Creating a portofolio.
asset1 <- asset("equity", "USD", 1000)
asset2 <- asset("hedge fund", "EUR", 2000)
life1 <- life(name        = c("pandemy", "longetivity", "storno"),
              currency    = c("CHF", "CHF", "CHF"),
              sensitivity = c(-100, -150, -130))
health1 <- health(name        = c("pandemy", "longetivity", "storno"),
                  currency    = c("CHF", "CHF", "CHF"),
                  sensitivity = c(100, 150, 130))
participation1 <- participation("CHF", 1000)
# valid portfolio parameters
   valid.param <- list(mvm = list(mvm.life = 2, mvm.health = 4, mvm.nonlife = 3),
                       rtkr = 0,
                       rtkg = 0,
                       correction.term = 2,
                       credit.risk = 3,
                       expected.insurance.result =  10^6,
                       expected.financial.result =  10^5)
pf <- portfolio(market.items   = list(asset1, asset2),
                participation.item  = participation1,
                life.item       = life1,
                health.item     = health1,
                base.currency  = "CHF",
                portfolio.parameters = valid.param)

}
\seealso{
\code{\link{summary.portfolio}}, \code{\link{print.portfolio}},
         \code{\link{asset}}, \code{\link{cashflow}},
         \code{\link{liability}}, \code{\link{fxForward}},
         \code{\link{assetForward}}, \code{\link{delta}},
         \code{\link{participation}}, \code{\link{life}},
         \code{\link{nonLifeRisk}}, \code{\link{health}},
         \code{\link{scenarioRisk}}.
}
