% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskFactor.R
\name{equity}
\alias{equity}
\title{Constructing an Equity (Risk Factor)}
\usage{
equity(name, type, currency, scale = NULL)
}
\arguments{
\item{name}{a character value of length one. This corresponds to the name in the covariance matrix of the \code{marketRisk}
to which the equity risk factor is mapped. This means that the risk factor change \eqn{\Delta RF_{t,i}}
in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"} will be assumed
to be modeled by the underlying normal random variable corresponding to \code{name} in the covariance matrix
(potentially scaled by \code{scale} if not \code{NULL}).}

\item{type}{a character value of length one. The type of equity. (e.g. \code{"equity"},
\code{"hedge fund"}, etc.). This parameter is a unique identifier of the equity risk factor
corresponding to the index \code{i} introduced above.
The following words are reserved and should not be used:
\itemize{
\item \code{currency}
\item \code{rate}
\item \code{pcRate}
\item \code{spread}
}}

\item{currency}{a character value of length one. The currency in which the underlying
asset with direct market price (\emph{"Aktiv mit direkt marktabhängigen Preisen"}) is valuated.
This refers to the currency corresponding to the index \code{j}
in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{scale}{a numeric value of length one. If not set \code{NULL},
this defines a scaled risk factor equal to \code{scale} times
the risk factor defined by \code{name} in the covariance matrix contained in \code{marketRisk}. By default its value is \code{scale = NULL}.}
}
\value{
An S3 object, instance of the class equity.
}
\description{
Constructor for the
  S3 class equity. It allows to define an equity-type risk factor. This risk factor refers
  to the \emph{"Preisrisikofaktor"} change \eqn{\Delta RF_{t,i}} for a certain index \code{i} in the
  valuation function for \emph{"Aktiven mit direkt marktabhängigen Preisen"} presented
  in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
}
\examples{
# constructing a non-scaled equity risk factor
# (assuming "MSCI_CHF" exists in marketRisk).
e <- equity(name = "MSCI_CHF",
            type = "equity",
            currency = "CHF")

# constructing a scaled equity risk factor
# (assuming "MSCI_CHF" exists in marketRisk).
e <- equity(name = "MSCI_CHF",
            type = "equity",
            currency = "CHF",
            scale = 0.5)

}
