% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.size.R
\name{summary.sspse}
\alias{summary.sspse}
\title{Summarizing Population Size Estimation Model Fits}
\usage{
\method{summary}{sspse}(object, support = 1000, HPD.level = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{"sspse"}, usually, a result of a call
to \code{\link{posteriorsize}}.}

\item{support}{the number of equally-spaced points to use for the support of
the estimated posterior density function.}

\item{HPD.level}{numeric; probability level of the highest probability
density interval determined from the estimated posterior.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
The function \code{summary.sspse} computes and returns a two row matrix of
summary statistics of the prior and estimated posterior distributions. The rows correspond to the \code{Prior} and the
\code{Posterior}, respectively.
The rows names are \code{Mean}, \code{Median}, \code{Mode}, \code{25\%}, \code{75\%}, and \code{90\%}.
These correspond to the distributional mean, median, mode, lower quartile, upper quartile and 90\% quantile, respectively.
}
\description{
This is the \code{summary} method for class \code{"sspse"} objects.
These objects encapsulate an estimate of the posterior distribution of
the population size based on data collected by Respondent Driven Sampling.
The approach approximates the RDS via the Sequential Sampling model of Gile
(2008).  As such, it is referred to as the Sequential Sampling - Population Size Estimate (SS-PSE).
It uses the order of selection of the sample to provide information
on the distribution of network sizes over the population members.
\code{summary} method for class \code{"sspse"}. posterior distribution of
the population size based on data collected by Respondent Driven Sampling.
The approach approximates the RDS via the Sequential Sampling model of Gile
(2008). As such, it is referred to as the Sequential Sampling - Population Size Estimate (SS-PSE).
It uses the order of selection of the sample to provide information
on the distribution of network sizes over the population members.
}
\details{
\code{print.summary.sspse} tries to be smart about formatting the
coefficients, standard errors, etc. and additionally gives
\sQuote{significance stars} if \code{signif.stars} is \code{TRUE}.

Aliased coefficients are omitted in the returned object but restored by the
\code{print} method.

Correlations are printed to two decimal places (or symbolically): to see the
actual correlations print \code{summary(object)$correlation} directly.
}
\examples{
\dontrun{
N0 <- 200
n <- 100
K <- 10

# Create probabilities for a Waring distribution
# with scaling parameter 3 and mean 5, but truncated at K=10.
probs <- c(0.33333333,0.19047619,0.11904762,0.07936508,0.05555556,
           0.04040404,0.03030303,0.02331002,0.01831502,0.01465201)
probs <- probs / sum(probs)

# Look at the degree distribution for the prior
# Plot these if you want
# plot(x=1:K,y=probs,type="l")
# points(x=1:K,y=probs)
#
# Create a sample
#
set.seed(1)
pop<-sample(1:K, size=N0, replace = TRUE, prob = probs)
s<-sample(pop, size=n, replace = FALSE, prob = pop)

out <- posteriorsize(s=s,interval=10)
plot(out, HPD.level=0.9,data=pop[s])
summary(out, HPD.level=0.9)
# Let's look at some MCMC diagnostics
plot(out, HPD.level=0.9,mcmc=TRUE)
}
}
\seealso{
The model fitting function \code{\link{posteriorsize}},
\code{\link{summary}}.
}
\keyword{models}

