% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_as_boundary.R
\name{spm_as_boundary}
\alias{spm_as_boundary}
\alias{spm_as_boundary,missing,ANY,ANY,ANY-method}
\alias{spm_as_boundary,ANY,missing,ANY,ANY-method}
\alias{spm_as_boundary,sf,character,missing,missing-method}
\alias{spm_as_boundary,sf,character,ANY,ANY-method}
\title{Create a sspm_boundary object}
\usage{
spm_as_boundary(
  boundaries,
  boundary,
  patches = NULL,
  points = NULL,
  boundary_area = NULL,
  patch_area = NULL
)

\S4method{spm_as_boundary}{missing,ANY,ANY,ANY}(
  boundaries,
  boundary,
  patches = NULL,
  points = NULL,
  boundary_area = NULL,
  patch_area = NULL
)

\S4method{spm_as_boundary}{ANY,missing,ANY,ANY}(
  boundaries,
  boundary,
  patches = NULL,
  points = NULL,
  boundary_area = NULL,
  patch_area = NULL
)

\S4method{spm_as_boundary}{sf,character,missing,missing}(
  boundaries,
  boundary,
  patches = NULL,
  points = NULL,
  boundary_area = NULL,
  patch_area = NULL
)

\S4method{spm_as_boundary}{sf,character,ANY,ANY}(
  boundaries,
  boundary,
  patches = NULL,
  points = NULL,
  boundary_area = NULL,
  patch_area = NULL
)
}
\arguments{
\item{boundaries}{\strong{[sf]} The sf object to cast.}

\item{boundary}{\strong{[character]} The column that contains the possible
subdivisions of the boundaries.}

\item{patches}{\strong{[sf]} Patches resulting from discretization.}

\item{points}{\strong{[sf]} Sample points used for discretization.}

\item{boundary_area}{\strong{[character]} The column that contains the area
of the subdivisions (optional).}

\item{patch_area}{\strong{[character]} The column that contains the area
of the patches (optional).}
}
\value{
An object of class \link[=sspm_boundary-class]{sspm_boundary} or
\link[=sspm_discrete_boundary-class]{sspm_discrete_boundary}.
}
\description{
Create a sspm_boundary object. A boundary object serves as a basis to encode
the spatial extent of the model.
}
\examples{
sfa_boundaries
bounds <- spm_as_boundary(boundaries = sfa_boundaries,
                          boundary = "sfa")
plot(bounds)

}
