% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wqg.R
\name{ssd_wqg_burrlioz}
\alias{ssd_wqg_burrlioz}
\title{Water Quality Guideline for Burrlioz}
\usage{
ssd_wqg_burrlioz(data, left = "Conc")
}
\arguments{
\item{data}{A data frame.}

\item{left}{A string of the column in data with the concentrations.}
}
\value{
A tibble of the 5\% hazard concentration with 95\% confidence intervals.
}
\description{
Calculates the 5\% Hazard Concentration (after rescaling the data)
using the same approach as Burrlioz based on 10,000 non-parametric bootstrap
samples.
}
\details{
Returns a tibble the model averaged 5\% hazard concentration with
standard errors, 95\% lower and upper confidence limits
and the number of bootstrap samples as well as the proportion of bootstrap
samples that successfully returned a likelihood
(convergence of the bootstrap sample is not required).
}
\examples{
\dontrun{
ssd_wqg_burrlioz(ssddata::ccme_boron)
}
}
\seealso{
\code{\link[=ssd_fit_burrlioz]{ssd_fit_burrlioz()}} and \code{\link[=ssd_hc_burrlioz]{ssd_hc_burrlioz()}}

Other wqg: 
\code{\link{ssd_wqg_bc}()}
}
\concept{wqg}
