% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_map.R
\name{group_map_dfr}
\alias{group_map_dfr}
\alias{group_map.tbl_svy}
\title{Apply a function to each group}
\usage{
group_map_dfr(.data, .f, ..., .keep = FALSE)

\method{group_map}{tbl_svy}(.data, .f, ..., .keep = FALSE)

group_map_dfr(.data, .f, ..., .keep = FALSE)
}
\arguments{
\item{.data}{A \code{tbl_svy object}}

\item{.f}{A function or purrr-style formula to apply to each group}

\item{...}{Other arguments passed to \code{.f}}

\item{.keep}{Whether the grouping variables are kept when passed into \code{.f}}
}
\value{
For \code{group_map} a list, for \code{group_map_dfr} a `tbl_df`, and for
  \code{group_walk} invisibly the original \code{tbl_svy}.
}
\description{
\code{group_map()}, \code{group_walk} and \code{group_map_dfr} are purrr-style
functions that can be used to iterate on grouped survey objects (note that
\code{group_map_dfr} replaces \code{dplyr::group_modify} because we are changing
the data from a \code{tbl_svy} to a regular tibble).
}
\examples{
data(api, package = "survey")
dstrata <- apistrat \%>\%
  as_survey_design(strata = stype, weights = pw)

results <- dstrata \%>\%
  group_by(both) \%>\%
  group_map(~survey::svyglm(api00~api99 + stype, .))

# group_map_dfr calls `bind_rows` on the list returned and includes
# grouping variables. This is most useful with a package like `broom`
# but could also be used with survey package functions.
result_coef <- dstrata \%>\%
  group_by(both) \%>\%
  group_map_dfr(
    ~data.frame(
      api99_coef = coef(survey::svyglm(api00~api99 + stype, .))[["api99"]]
    )
  )

}
