% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_statistics_helpers.R
\name{set_survey_vars}
\alias{set_survey_vars}
\title{Set the variables for the current survey variable}
\usage{
set_survey_vars(.svy, x, name = "__SRVYR_TEMP_VAR__", add = FALSE)
}
\arguments{
\item{.svy}{A survey object}

\item{x}{A vector to be included in the variables portion of the survey object}

\item{name}{The name of the variable once it is added. Defaults to `__SRVYR_TEMP_VAR__`
which is formatted weirdly to avoid name collisions.}

\item{add}{FALSE, the default, overwrite all current variables. If TRUE, will add
this variable instead.}
}
\value{
a tbl_svy with the variables modified
}
\description{
This is a helper to allow srvyr's syntactic style. In general, users
will not have to worry about setting variables in a survey object
unless they are trying to extend srvyr. This function helps convert a vector
to a variable in the correct part of a survey object's structure so that
functions can refer to it using the survey package's formula notation.
See \code{vignette("extending-srvyr")} for more details.
}
