% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_rbind.R
\name{sp_rbind}
\alias{sp_rbind}
\title{Combine rows from GRTS or IRS samples.}
\usage{
sp_rbind(object, siteuse = NULL)
}
\arguments{
\item{object}{The design sites (output from \code{grts()} or \code{irs()}).}

\item{siteuse}{A character vector of site types to return. Can contain
\code{"Legacy"} (for legacy sites), \code{"Base"} (for base sites),
\code{"Over"} (for \code{n_over} replacement sites), and \code{"Near"}
(for \code{n_near} replacement sites). The default is \code{NULL}, which
returns all non-\code{NULL} output from \code{object$sites_legacy},
\code{object$sites_base}, \code{object$sites_over}, and \code{object$sites_near}.}
}
\value{
A single \code{sf} object containing all requested design sites.
}
\description{
This function row binds the \code{sites_legacy}, \code{sites_base},
\code{sites_over}, and \code{sites_near} objects from a GRTS or IRS sample
into a single \code{sf} object. This function is most useful when a single
\code{sf} object that contains all design sites is desired
(e.g. writing out a single shapefile using \code{sf::write_sf()}).
}
\examples{
\dontrun{
sample <- grts(NE_Lakes, 50, n_over = 10)
sample <- sp_rbind(sample)
write_sf(sample, "mypath/sample.shp")
}
}
\author{
Michael Dumelle \email{Dumelle.Michael@epa.gov}
}
