% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_summary.R
\name{pd_summary}
\alias{pd_summary}
\title{Summary characteristics of a panel revisit design}
\usage{
pd_summary(object, visitdsgn = NULL, ...)
}
\arguments{
\item{object}{Two-dimensional array from \code{panel_design} and dimnames specifying revisit
panel design. Typically, array is output from \code{revisit_dsgn}, \code{revisit_bibd} or
\code{revisit_rand} functions.}

\item{visitdsgn}{Two-dimensional array with same dimensions as \code{paneldsgn}
specifying the number of times a sample unit is sampled at each time
period. Default is \code{visitdsgn=NULL}, where default assumes that a sample unit
will be sampled only once at each time period.}

\item{...}{Additional arguments (S3 consistency)}
}
\value{
List of six elements.
  \describe{
    \item{\code{n_panel}}{ number of panels in revisit design}
    \item{\code{n_period}}{ number of time periods in revisit design}
    \item{\code{n_total}}{ total number of sample events across all panels and all
      time periods, accounting for \code{visitdsgn}, that will be sampled in the revisit
      design}
    \item{\code{n_periodunit}}{ vector of the number of time periods a unit will be
      sampled in each panel}
    \item{\code{n_unitpnl}}{ vector of the number of sample units, accounting for
      \code{visitdsgn}, that will be sampled in each panel}
    \item{\code{n_unitperiod}}{ vector of the number of sample units, accounting for
      \code{visitdsgn}, that will be sampled during each time period}
    \item{\code{ncum_unit}}{ vector of the cumulative number of unique units that will
  be sampled in time periods up to and including the current time period.}
  }
}
\description{
Panel revisit design characteristics are summarized: number of panels, number
of time periods, total number of sample events for the revisit design, total
number of sample events for each panel, total number of sample events for
each time period and cumulative number of unique units sampled by time
periods.
}
\details{
The revisit panel design and the visit design (if present) are
  summarized. Summaries can be useful to know the effort required to complete
  the survey design. See the values returned for the summaries that are
  produced.
}
\examples{
# Serially alternating panel revisit design summary
sa_dsgn <- revisit_dsgn(20, panels = list(SA60N = list(
  n = 60, pnl_dsgn = c(1, 4),
  pnl_n = NA, start_option = "None"
)), begin = 1)
pd_summary(sa_dsgn)
# Add visit design where first panel is sampled twice at every time period
sa_visit <- sa_dsgn
sa_visit[sa_visit > 0] <- 1
sa_visit[1, sa_visit[1, ] > 0] <- 2
pd_summary(sa_dsgn, sa_visit)
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}
}
\keyword{survey}
