% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdf_plot.R
\name{cdf_plot}
\alias{cdf_plot}
\title{Plot a cumulative distribution function (CDF)}
\usage{
cdf_plot(
  cdfest,
  var = NULL,
  subpop = NULL,
  subpop_level = NULL,
  units_cdf = "Percent",
  type_cdf = "Continuous",
  log = "",
  xlab = NULL,
  ylab = NULL,
  ylab_r = NULL,
  main = NULL,
  legloc = NULL,
  confcut = 0,
  conflev = 95,
  cex.main = 1.2,
  cex.legend = 1,
  ...
)
}
\arguments{
\item{cdfest}{Data frame with the same structure as the "CDF" output from
\code{cont_analysis}.}

\item{var}{If \code{cdfest} has multiple variables in the "Indicator" column,
then \code{var} is the single variable to be plotted. The default is
\code{NULL}, which assumes that only one variable is in the "Indicator"
column of \code{cdfest}.}

\item{subpop}{If \code{cdfest} has multiple variables in the "Type" column,
then \code{subpop} is the single variable to be plotted. The default is
\code{NULL}, which assumes that only one variable is in the "Type"
column of \code{cdfest}.}

\item{subpop_level}{If \code{cdfest} has multiple levels of \code{subpop}
in the "Subpopulation" column,
then \code{subpop_level} is the single level to be plotted. The default is
\code{NULL}, which assumes that only one level is in the "Subpopulation"
column of \code{cdfest}.}

\item{units_cdf}{Indicator for the label utilized for the left side y-axis
and the values used for the left side y-axis tick marks, where "Percent"
means the label and values are in terms of percent of the population, and
"Units" means the label and values are in terms of units (count, length,
or area) of the population.  The default is "Percent".}

\item{type_cdf}{Character string consisting of the value "Continuous" or
"Ordinal" that controls the type of CDF plot.  The default is "Continuous".}

\item{log}{Character string consisting of the value "" or "x" that
controls whether the x axis uses the original scale ("") or the base 10
logarithmic scale ("x").  The default is "".}

\item{xlab}{Character string providing the x-axis label.  If this argument
equals NULL, then the indicator name is used as the label.  The default is
NULL.}

\item{ylab}{Character string providing the left side y-axis label.  If
argument units_cdf equals "Units", a value should be provided for this
argument.  Otherwise, the label will be "Percent".  The default is
"Percent".}

\item{ylab_r}{Character string providing the label for the right side y-axis
(and, hence, determining the values used for the right side y-axis tick
marks), where NULL means a right side y-axis is not created.  If this
argument equals "Same", the right side y-axis will have the same label and
tick mark values as the left side y-axis.  If this argument equals a
character string other than "Same", the right side y-axis label will be the
value provided for argument ylab_r, and the right side y-axis tick mark
values will be determined by the choice not utilized for argument
units_cdf, which means that the default value of argument units_cdf (i.e.,
"Percent") will result in the right side y-axis tick mark values being
expressed  in terms of units of the population (i.e., count, length, or
area).  The default is NULL.}

\item{main}{Character string providing the plot title.  The default is
NULL.}

\item{legloc}{Indicator for location of the plot legend, where "BR" means
bottom right, "BL" means bottom left, "TR" means top right, "TL" means
top left, and NULL means no legend.  The default is NULL.}

\item{confcut}{Numeric value that controls plotting confidence limits at
the CDF extremes.  Confidence limits for CDF values (percent scale) less
than confcut or greater than 100 minus confcut are not plotted.  A value of
zero means confidence limits are plotted for the complete range of the CDF.
The default is 0.}

\item{conflev}{Numeric value of the confidence level used for confidence
limits. The default is 95.}

\item{cex.main}{Expansion factor for the plot title.  The default is 1.2.}

\item{cex.legend}{Expansion factor for the legend title. The default is 1.}

\item{...}{Additional arguments passed to the \code{plot.default} function
(aside from those already used and \code{ylim}).}
}
\value{
A plot of a variable's CDF estimates associated confidence limits.
}
\description{
This function creates a CDF plot.  Input data for the plots is provided by a
data frame with the same structure as the "CDF" output from  \code{cont_analysis}.
Confidence limits for the CDF also are plotted.
}
\examples{
dframe <- data.frame(
  siteID = paste0("Site", 1:100),
  wgt = runif(100, 10, 100),
  xcoord = runif(100),
  ycoord = runif(100),
  stratum = rep(c("Stratum1", "Stratum2"), 50),
  ContVar = rnorm(100, 10, 1),
  All_Sites = rep("All Sites", 100),
  Resource_Class = rep(c("Good", "Poor"), c(55, 45))
)
myvars <- c("ContVar")
mysubpops <- c("All_Sites", "Resource_Class")
mypopsize <- data.frame(
  Resource_Class = c("Good", "Poor"),
  Total = c(4000, 1500)
)
myanalysis <- cont_analysis(dframe,
  vars = myvars, subpops = mysubpops,
  siteID = "siteID", weight = "wgt", xcoord = "xcoord", ycoord = "ycoord",
  stratumID = "stratum", popsize = mypopsize
)
keep <- with(myanalysis$CDF, Type == "Resource_Class" &
  Subpopulation == "Good")
par(mfrow = c(2, 1))
cdf_plot(myanalysis$CDF[keep, ],
  xlab = "ContVar",
  ylab = "Percent of Stream Length", ylab_r = "Stream Length (km)",
  main = "Estimates for Resource Class: Good"
)
cdf_plot(myanalysis$CDF[keep, ],
  xlab = "ContVar",
  ylab = "Percent of Stream Length", ylab_r = "Same",
  main = "Estimates for Resource Class: Good"
)
}
\seealso{
\describe{
  \item{\code{\link{cont_cdfplot}}}{for creating a PDF file containing CDF
    plots}
  \item{\code{\link{cont_cdftest}}}{for CDF hypothesis testing}
  }
}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\keyword{survey}
