% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodalbers.R
\name{geodalbers}
\alias{geodalbers}
\title{Project Latitude/Longitude to Albers Projection}
\usage{
geodalbers(lon, lat, sph = "GRS80", clon = -96, clat = 23,
  sp1 = 29.5, sp2 = 45.5)
}
\arguments{
\item{lon}{Vector of longitude (decimal degrees) values to be projected to
Albers.}

\item{lat}{Vector of latitude (decimal degrees) values to be projected to
Albers.}

\item{sph}{Spheroid options: Clarke1866, GRS80, WGS84.  The default is
GRS80.}

\item{clon}{Center longitude (decimal degrees).  The default is -96.}

\item{clat}{Origin latitude (decimal degrees).  The default is 23.}

\item{sp1}{Standard parallel 1 (decimal degrees).  The default is 29.5.}

\item{sp2}{Standard parallel 2 (decimal degrees).  The default is 45.5.}
}
\value{
Data frame of Albers x-coordinate and y-coordinate projections for
  latitude and longitude.
}
\description{
Project Latitude/Longitude to Albers Projection
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}
}
