% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markedIPPP_mix.R
\name{plot_MPP_fields}
\alias{plot_MPP_fields}
\title{Plot the mark probability fields}
\usage{
plot_MPP_fields(MPP, gammas, r, discrete_mark = TRUE, grayscale = FALSE,
  truncate = FALSE, open_new_window = FALSE, LL = 128)
}
\arguments{
\item{MPP}{A marked point pattern as an
object of class \code{\link[spatstat]{ppp}}.}

\item{gammas}{For discrete marks (\code{discrete_mark=TRUE}), this is
a vector of length equal to the number of marks.
These parameters should typically be non-negative and
they represent weights affecting the probability
fields of each mark. For values close to 0, we
get higher probabilities of observing this mark.
Large positive values lead to small probabilities of observing
the corresponding mark.}

\item{r}{Radius used to define the
neighborhood system. Any two locations
within this distance are considered
neighbors.}

\item{discrete_mark}{Logical flag indicating whether the mark is discrete or not.
Default is TRUE. For continuous marks set this to FALSE.}

\item{grayscale}{Logical to request plots in grayscale.}

\item{truncate}{Logical variable indicating to discard points
if they are not within the window of observation. Default is FALSE.}

\item{open_new_window}{Logical requesting a new window
for the plot(s).}

\item{LL}{Length of the side of the square grid.
The larger this value is, the better the picture resolution.}
}
\description{
The function displays the mark probability fields
for each location of a marked
point pattern. These fields are simply the
probabilities of observing the corresponding
mark value at that location.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#plot_MPP_fields}
}
\examples{

\dontrun{
newMPP=rMIPPP_cond_loc(gammas=c(.1,.2,.5), r=.5)
plot(newMPP$surf,main="True IPPP intensity surface for the locations")
plot_MPP_fields(newMPP$genMPP,newMPP$gammas,newMPP$r)
plot_MPP_fields(newMPP$genMPP,newMPP$gammas,1)
plot_MPP_fields(newMPP$genMPP,newMPP$gammas,1.5)
plot_MPP_fields(newMPP$genMPP,newMPP$gammas,2)}

}
\author{
Sakis Micheas
}
\seealso{
\code{\link{rMIPPP_cond_loc}}
}

