% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_post.R
\name{GetMAPEst}
\alias{GetMAPEst}
\title{Retrieve the surface of MAP estimators}
\usage{
GetMAPEst(fit, burnin = floor(fit$L/10), vals)
}
\arguments{
\item{fit}{Object of class \code{damcmc_res} or \code{bdmcmc_res}.}

\item{burnin}{Number of initial realizations to discard. By default, it is 1/10 of the total number of iterations.}

\item{vals}{Contains the density values over the point pattern and realizations in the \code{fit} object. This
can be obtained via a call to \code{\link{GetDensityValues}}. If this argument is missing
then the density values are computed herein before computing the MAP estimates.}
}
\value{
An object of type \code{intensity_surface}.
}
\description{
The function calculates the Maximum A Posteriori (MAP)
estimate of the IPPP mixture intensity surface parameters. Use function
\code{\link{GetPMEst}} if you want the surface of posterior means.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#GetMAPEst}
}
\examples{

\dontrun{
truemix_surf <- rmixsurf(m = 3, lambda=100, xlim = c(-3,3), ylim = c(-3,3))
plot(truemix_surf,main="True IPPP intensity surface")
genPPP=rsppmix(intsurf = truemix_surf, truncate = FALSE)
#the larger the number of realizations the better
fit <- est_mix_damcmc(genPPP, m = 3,L=100000)
MAPest=GetMAPEst(fit)
plot(GetPMEst(fit),main="IPPP intensity surface of posterior means")
plot(MAPest,main="IPPP intensity surface of MAP estimates")
fitBD <- est_mix_bdmcmc(pp = genPPP, m = 5)
MAPest=GetMAPEst(fitBD)
plot(MAPest,main="IPPP intensity surface of MAP estimates for MAP m")}

}
\author{
Sakis Micheas
}
\seealso{
\code{\link{est_mix_damcmc}},
\code{\link{rmixsurf}},
\code{\link{rsppmix}},
\code{\link{GetPMEst}}
}

