% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfokcv.R
\name{rfokcv}
\alias{rfokcv}
\title{Cross validation, n-fold for the hybrid method of random forest and ordinary kriging (RFOK)}
\usage{
rfokcv(longlat, trainx, trainy, cv.fold = 10, mtry = function(p) max(1,
  floor(sqrt(p))), ntree = 500, nmax = 12, vgm.args = ("Sph"),
  block = 0, predacc = "VEcv", ...)
}
\arguments{
\item{longlat}{a dataframe contains longitude and latitude of point
samples (i.e., trainx and trainy).}

\item{trainx}{a dataframe or matrix contains columns of predictive variables.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in trainx.}

\item{cv.fold}{integer; number of folds in the cross-validation. if > 1,
then apply n-fold cross validation; the default is 10, i.e., 10-fold cross
validation that is recommended.}

\item{mtry}{a function of number of remaining predictor variables to use as
the mtry parameter in the randomForest call.}

\item{ntree}{number of trees to grow. This should not be set to too small a
number, to ensure that every input row gets predicted at least a few times.
By default, 500 is used.}

\item{nmax}{for local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is
defined in terms of the space of the spatial locations. By default, 12.}

\item{vgm.args}{arguments for vgm, e.g. variogram model of response
variable and anisotropy parameters. see notes vgm in gstat for details.
By default, "Sph" is used.}

\item{block}{block size. see krige in gstat for details.}

\item{predacc}{can be either "VEcv" for vecv or "ALL" for all measures
in function pred.acc.}

\item{...}{other arguments passed on to randomForest or gstat.}
}
\value{
A list with the following components:
for numerical data: me, rme, mae, rmae, mse, rmse, rrmse, vecv and e1; or vecv.
}
\description{
This function is a cross validation function for the hybrid
method of random forest and ordinary kriging (RFOK).
}
\note{
This function is largely based on rf.cv (see Li et al. 2013) and
rfcv in randomForest.  When 'A zero or negative range was fitted to
variogram' occurs, to allow gstat running, the range was set to be positive by
using min(vgm1$dist). In this case, caution should be taken in applying this
method, although sometimes it can still outperform IDW and OK.
}
\examples{
\dontrun{
data(petrel)

rfokcv1 <- rfokcv(petrel[, c(1,2)], petrel[, c(1,2, 6:9)], petrel[, 5],
predacc = "ALL")
rfokcv1

n <- 20 # number of iterations, 60 to 100 is recommended.
VEcv <- NULL
for (i in 1:n) {
rfokcv1 <- rfokcv(petrel[, c(1,2)], petrel[, c(1,2,6:9)], petrel[, 5],
predacc = "VEcv")
VEcv [i] <- rfokcv1
}
plot(VEcv ~ c(1:n), xlab = "Iteration for RFOK", ylab = "VEcv (\%)")
points(cumsum(VEcv) / c(1:n) ~ c(1:n), col = 2)
abline(h = mean(VEcv), col = 'blue', lwd = 2)

n <- 20 # number of iterations, 60 to 100 is recommended.
measures <- NULL
for (i in 1:n) {
rfokcv1 <- rfokcv(petrel[, c(1,2)], petrel[, c(1,2,6:9)], petrel[, 5],
predacc = "ALL")
measures <- rbind(measures, rfokcv1$vecv)
}
plot(measures ~ c(1:n), xlab = "Iteration for RFOK", ylab = "VEcv (\%)")
points(cumsum(measures) / c(1:n) ~ c(1:n), col = 2)
abline(h = mean(measures), col = 'blue', lwd = 2)
}

}
\references{
Li, J. 2013. Predicting the spatial distribution of seabed
gravel content using random forest, spatial interpolation methods and their
hybrid methods. Pages 394-400  The International Congress on Modelling and
Simulation (MODSIM) 2013, Adelaide.

Liaw, A. and M. Wiener (2002). Classification and Regression by
randomForest. R News 2(3), 18-22.
}
\author{
Jin Li
}
