% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitSelect_coef.R
\name{splitSelect_coef}
\alias{splitSelect_coef}
\title{Split Selection for Regression - Coefficients Generation}
\usage{
splitSelect_coef(
  x,
  y,
  variables.split,
  intercept = TRUE,
  family = c("gaussian", "binomial")[1],
  group.model = c("glmnet", "LS", "Logistic")[1],
  lambdas = NULL,
  alphas = 0
)
}
\arguments{
\item{x}{Design matrix.}

\item{y}{Response vector.}

\item{variables.split}{A vector with the split of the variables into groups as values.}

\item{intercept}{Boolean variable to determine if there is intercept (default is TRUE) or not.}

\item{family}{Description of the error distribution and link function to be used for the model. Must be one of "gaussian" or "binomial".}

\item{group.model}{Model used for the groups. Must be one of "glmnet" or "LS".}

\item{lambdas}{The shinkrage parameters for the "glmnet" regularization. If NULL (default), optimal values are chosen.}

\item{alphas}{Elastic net mixing parameter. Should be between 0 (default) and 1.}
}
\value{
A vector with the regression coefficients for the split.
}
\description{
\code{splitSelect_coef} generates the coefficients for a particular split of variables into groups.
}
\examples{
# Setting the parameters
p <- 6
n <- 30
n.test <- 5000
group.beta <- -3
beta <- c(rep(1, 2), rep(group.beta, p-2))
rho <- 0.1
r <- 0.9
SNR <- 3
# Creating the target matrix with "kernel" set to rho
target_cor <- function(r, p){
  Gamma <- diag(p)
  for(i in 1:(p-1)){
    for(j in (i+1):p){
      Gamma[i,j] <- Gamma[j,i] <- r^(abs(i-j))
    }
  }
  return(Gamma)
}
# AR Correlation Structure
Sigma.r <- target_cor(r, p)
Sigma.rho <- target_cor(rho, p)
sigma.epsilon <- as.numeric(sqrt((t(beta) \%*\% Sigma.rho \%*\% beta)/SNR))
# Simulate some data
x.train <- mvnfast::rmvn(30, mu=rep(0,p), sigma=Sigma.r)
y.train <- 1 + x.train \%*\% beta + rnorm(n=n, mean=0, sd=sigma.epsilon)
x.test <- mvnfast::rmvn(n.test, mu=rep(0,p), sigma=Sigma.rho)
y.test <- 1 + x.test \%*\% beta + rnorm(n.test, sd=sigma.epsilon)

# Generating the coefficients for a fixed split
splitSelect_coef(x.train, y.train, variables.split=matrix(c(1,2,1,2,1,2), nrow=1))

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
